/*********************************************************************
 *  SPDX-License-Identifier: MIT                                     *
 *  Copyright (C) 2014-2023 by Helge Kortendieck  alan@kasmithee.de  *
 *                                                                   *
 *  This file is part of tlmb.										 *
 *  edit a m3u playlist functions                                    *
 *********************************************************************/
#include "playlistedit.h"

EditPlayList::EditPlayList(QDialog* parent)
	: QDialog(parent)
{
	uiEpl.setupUi(&wEpl);
	uiEpl.pb_Up->setIcon(QIcon("/usr/share/tlmb/icons/scalable/up.svg"));
	uiEpl.pb_Down->setIcon(QIcon("/usr/share/tlmb/icons/scalable/down.svg"));
	uiEpl.pb_Drop->setIcon(QIcon("/usr/share/tlmb/icons/scalable/drop.svg"));
	connect(uiEpl.pb_Apply, SIGNAL(clicked()), this, SLOT(eplDlgApply()));
	connect(uiEpl.pb_Cancel, SIGNAL(clicked()), this, SLOT(eplDlgCancel()));
	connect(uiEpl.pb_Down, SIGNAL(clicked()), this, SLOT(eplSongDown()));
	connect(uiEpl.pb_Drop, SIGNAL(clicked()), this, SLOT(eplSongDrop()));
	connect(uiEpl.pb_Up, SIGNAL(clicked()), this, SLOT(eplSongUp()));
}

EditPlayList::~EditPlayList()
{
}


void EditPlayList::eplDlgApply()
{
	emit sigEplTlmbM3uUpd(eplLiItems);
	emit sigEplTlmbDelete();
}

void EditPlayList::eplDlgCancel()
{
	emit sigEplTlmbDelete();
}

void EditPlayList::eplDlgShow(const QString& eplsD, const QString& eplsD2, const QList<StrM3u>& eplLiItemsD)	// show edit playlist dialog - allowed path, path n name of m3u, m3u struct list
{
//cout << "eplDlgShow: reached " << endl;                                               // *****  debug  *****
	uiEpl.l_Playlist->setText(eplsD2);
	eplLiItems = eplLiItemsD;
	epliCount = eplLiItems.count();
	epliD2 = -1;
	eplDlgPop();
	wEpl.show();
}

void EditPlayList::eplDlgPop()					// populate list widget with songs
{
//cout << "eplDlgPop: reached " << endl;                                               // *****  debug  *****
	uiEpl.lw_PlayList->clear();
	if (epliCount > 0) {
		for (epliD = 0; epliD < epliCount; epliD++) {
			eplStrM3uD = eplLiItems.at(epliD);
			eplsD2 = "";
			if (eplStrM3uD.sSongName != "" and eplStrM3uD.sSongName.contains("Album artist") == false) {
				eplsD2 = eplStrM3uD.sSongName;
			}
			
			if (eplsD2 == "")
				if (eplStrM3uD.sSongPathName != "") {
					eplsD2 = eplStrM3uD.sSongPathName;
				} else {
					eplsD2 = tr("No name or path. Should never happen?");
				}
			QListWidgetItem *newSongItem = new QListWidgetItem(eplsD2);
			uiEpl.lw_PlayList->addItem(newSongItem);
		}
	}
	if (epliD2 > -1) {
		uiEpl.lw_PlayList->setCurrentRow(epliD2);
	}
}


void EditPlayList::eplSongDown()				// move selected song down by 1 position
{
	epliD2 = uiEpl.lw_PlayList->currentRow();
//cout << "eplSongDown: epliD2 = " << QString::number(epliD2).toStdString() << endl;                                               // *****  debug  *****
	if (epliD2 > -1 and epliD2 < epliCount -1) {
		eplLiItems.move(epliD2, epliD2 + 1);
		epliD2 = epliD2 + 1;
		eplDlgPop();
	}
}

void EditPlayList::eplSongDrop()				// drop selected song from playlist
{
	epliD2 = uiEpl.lw_PlayList->currentRow();
	if (epliD2 > -1) {
		QMessageBox msgBox;
		msgBox.setText("Sure to drop the selected song from the playlist?");
			msgBox.setStandardButtons(QMessageBox::Yes | QMessageBox::No);
			msgBox.setDefaultButton(QMessageBox::No);
		epliRet = msgBox.exec();					// Yes=16384, No=65536 - sigh!
//cout << "eplSongDrop: epliRet = " << QString::number(epliRet).toStdString() << endl;                                               // *****  debug  *****
		if (epliRet == 16384){
			eplLiItems.removeAt(epliD2);
			epliCount = epliCount - 1;
			epliD2 = -1;
			eplDlgPop();
		}
	}
}

void EditPlayList::eplSongUp()					// move selected song up by 1 position
{	
	epliD2 = uiEpl.lw_PlayList->currentRow();
	if (epliD2 > 0) {
		eplLiItems.move(epliD2, epliD2 - 1);
		epliD2 = epliD2 - 1;
		eplDlgPop();
	}
}
