/*********************************************************************
 *  SPDX-License-Identifier: MIT									 *
 *  Copyright (C) 2007-2024 by Helge Kortendieck  alan@kasmithee.de  *
 *                                                                   *
 *  This file is part of tlmb.                                       *
 *********************************************************************/
#include "abouthelp.h"

aboutHelp::aboutHelp(QDialog* parent)
		: QDialog(parent)
{
	uih.setupUi(&wHelp);
	connect(uih.pB_Close, SIGNAL(clicked()), this, SLOT(dlgClose()));
}

aboutHelp::~aboutHelp()
{
}

void aboutHelp::dlgShow(int iD)			// show dialog: 1=about, 2=Help, 3=no system tray
{
//cout << "dlgShow reached : " << endl;
	iDlg = iD;
	if (wHelp.isVisible() == true) {
		wHelp.hide();
	}
	textSet();
	if (iDlg == 1) {
// ** about
		uih.tb_Help->setHtml(sHelp);
		wHelp.setWindowTitle(tr("about tlmb"));
		wHelp.resize(625, 260);
	} else if (iDlg == 2) {
// ** help
		uih.tb_Help->setHtml(sHelp);
		wHelp.setWindowTitle(tr("tlmb - help"));
		wHelp.showFullScreen();
	}
	if (iDlg == 1) {							// 1=about
		qPos = QCursor::pos();
		iD = qPos.x() - 450;
		if (iD < 0) {
			iD = 0;
		}
		iD2 = qPos.y() - 175;
		if (iD2 < 0) {
			iD2 = 0;
		}
		wHelp.move(iD, iD2);
	}
	wHelp.show();
}

void aboutHelp::dlgClose()
{
	wHelp.hide();
	emit sigDelAhw();
}

void aboutHelp::textSet()
{
	if (iDlg == 1) {
		sHelp = tr("<html><body>"
                  "tlmb - the little music box.<p>"
                  "Qt6 based.<p>"
                  "Version 0.9.9, Copyright 2021-2025 by Helge Kortendieck<p>"
                  "This program is released under the MIT license.<br>"
                  "</body></html>" );
	} else if (iDlg == 2) {
		sHelp = tr("<html><body>"
                  "<a name=""Top""><b>Table of content</b></a><br>"
                  "<a href=""#Intro"">Introduction</a><br>"
                  "<a href=""#Usage"">Usage</a><br>"
                  "<a href=""#Example"">Example</a><br>"
                  "<a href=""#Navigation"">Navigation</a><br>"
                  "<a href=""#Configuration"">System configuration - Mpv, font size</a><br>"
                  "<a href=""#Settings"">Program settings</a><br>"
                  "<a href=""#Options"">Options</a><br>"
                  "<a href=""#Credits"">Credits</a><p>"

                  "<hr>"
                  "<a name=""Intro""><b><u>Introduction</u></b></a><p>"
                  "tlmb - the little music player - is an easy to use, Qt6 based music player.<br>"
                  "It provides an easy way to control a music file collection with a remote keyboard. Basically a special type of file manager optimized to easily play music files.<br>"
				  "But for this tlmb requires and expects that the music collection is organised in a file system tree. It cannot crawl over your data and collect any possible music file.<p>"

				  "The player to use can now be freely configured in the settings dialog. 3 players can be pre-configured from which the active one can be selected via radiobutton.<br>"
				  "In the following mpv is used as the player. This way tlmb can take advantage of all the great media knowledge from mpv (ffmpeg).<br>"
				  "mpv is started as a standalone player, not under the control of tlmb. While mpv is running, it should have the focus and it's (mpv's) keyboard shortcuts should work.<br>"
				  "mpv allows playing pure audio files as well as music videos.<br>"
				  "Due to the video overlay of mpv, tlmb might be more targeted for playing music videos. But it will play pure audio files just fine.<p>"

				  "Playlists following the *.m3u standard are supported.<p>"
                  "<a href=""#Top"">back to top</a><p>"

                  "<hr>"
                  "<a name=""Usage""><b><u>Starting</u></b></a><p>"
                  "The program should be started without arguments.<p>"
                  
                  "As tlmb requires the music collection follwing the file system structure, a root directory has to be set at first under settings from the menu.<br>"
                  "Below that directory, the first level of directories is used for different music types, e. g. classic, non classic or further fine grained like Pop, Rock, etc. .<br>"
				  "Below each music type directory, a second level of directories can be defined e. g. to seperate different singers or bands.<br>"
				  "The directories for the music types, the sub directories for singers/bands and the songs in them have to be created outside of tlmb e. g. with a file manager.<br>"
				  "E. g. we set a start/entry directory under settings via the menu like: /tlmb.<br>"
				  "Then we create a music type directory for e. g. classic: /tlmb/classic.<br>"
				  "Then we create the second level directories for singers/bands like: /tlmb/classic/LeaDesandre, /tlmb/classic/PatriciaPetibon, /tlmb/nonClassic/BlackDub etc. and fill them with the songs pure audio and/or video.<p>"
				  
				  "During program start the available directories and their contents will be read.<br>"
				  "The music type to listen to can be set from the available directories with the first combo box (it will be automatically selected on the next start, if available).<br>"
				  "Depending on the selection of the 1st combo box, the 2nd combo box with the singers/bands will be filled and the last setting will also be selected again on the next start, if available.<br>"
				  "The available songs for the selected music type/singer_band combination will be listed for selection shown .<br>"
				  "Select one or several song(s), hit the MEDIAPLAY button and the music will be played via mpv. To stop continous playing press 'q' within the first 5 seconds after a song has started.<p>"
				  
				  "Playlists will be created in a 'playlists' directory in every directory below and including the root directory.<br>"
				  "These and every directory started with 'ignore' will not be shown in the comboboxes. So use the 'ignore' prefix if a directory is not ment to be shown in the comboboxes.<br>"
				  "You can set a playlist to add songs to separately from the playlist to play from. However, they can also be the same, but songs can only be added once to a playlist.<p>"
                  "<a href=""#Top"">back to top</a><p>"

                  "<hr>"
                  "<a name=""Example""><b><u>Example</u></b></a><p>"
                  "Let's assume we have a (very) small music collection, but want to play it with the little music box using a remote control.<br>"
                  "We create the following file structure (with a file manager) according our music files (a mix of videos and audio only files):<p>"
                   
                  "/tlmb<br>"
                  "/tlmb/classic<br>"
                  "/tlmb/classic/ElinaGaranca<br>"
                  "/tlmb/classic/ElinaGaranca/AveMaria.webm<br>"
                  "/tlmb/classic/LeaDesandre<br>"
                  "/tlmb/classic/LeaDesandre/JudithaTriumphans.mkv<br>"
                  "/tlmb/classic/LeaDesandre/A_Chloris.mkv<br>"
                  "/tlmb/classic/PatriciaPetibon<br>"
                  "/tlmb/classic/PatriciaPetibon/LasciaCh_IoPianga.webm<br>"
                  "/tlmb/nonclassic<br>"
                  "/tlmb/nonclassic/BlackDub<br>"
                  "/tlmb/nonclassic/BlackDub/MayBeTheLastTime.mkv<br>"
				  "/tlmb/nonclassic/BobDylan<br>"
				  "/tlmb/nonclassic/BobDylan/LayLadyLay.flac<br>"
				  "/tlmb/nonclassic/JoanBaez<br>"
				  "/tlmb/nonclassic/JoanBaez/BrothersInArms.mp3<p>"

				  "So we laid out our structure:<p>"

				  "Setting tlmb's root directory:<br>"
				  "The program's root directory is set in the menu under Settings. '/tlmb' in our example.<br>"
				  "The base directory is not intended to be altered via the remote control.<br>"
				  "Note, that playlists across music types will be created and saved in the directory 'playlists' in this directory.<br>"
				  "This and any directory starting with 'ignore' will not been shown in the music type combo box.<p>"

				  "Selecting the music type:<br>"
				  "In our example the music type combo box has been filled automatically with 2 entries: 'classic' and 'nonclassic'. Read from the file system.<br>"
				  "We select 'classic' for now.<br>"
				  "Note, that playlists per music type will be created and saved in the directory 'playlists' in every music type directory. E. g. in this example one in classic, one in nonclassic.<br>"
				  "This and any directory starting with 'ignore' will not been shown in the artist/band combo box.<p>"
				  
			      "Selecting the artist:<br>"
				  "Based on the selection in the 1st combo box, 'classic', the 2nd combo box, artist, has been filled with 3 entries (in our example): 'ElinaGaranca', 'LeaDesandre' and 'PatriciaPetibon' .<br>"
				  "We select 'LeaDesandre' for now.<br>"
				  "Note, that playlists per artist/band will be created and saved in the directory 'playlists' in every artist/band directory. E. g. in this example one in 'ElinaGaranca', one in 'LeaDesandre', etc. .<p>"
				  
				  "Selecting the song(s) to play:<br>"
				  "Based on the selection in the 1st and 2nd combo box, the song list has been filled with 2 songs: 'JudithaTriumphans.mkv' and 'A_Chloris.mkv' .<br>"
				  "Using the remote control we can now select the song to play. Double-click on it or hit OK/ENTER to play it.<p>"

				  "mpv will be started with the song to play. When configured to run in fullscreen, it will cover tlmb while running.<br>"
				  "As mpv now has the focus, the remote can be used to stop playing or close the program (focus should get back to tlmb).<p>"
                  "<a href=""#Top"">back to top</a><p>"

				  "<hr>"
                  "<a name=""Navigation""><b><u>Navigation</u></b></a><p>"
                  "tlmb is optimized to be used with a remote keyboard. This turned out to be more convenient then using a remote control.<p>"
                  "The comboboxes can be directly accessed with the key combinations SHIFT + F1-F8 .<br>"
                  "The song list can be reached with SHIFT + F9 .<br>"
                  "Start playing the selected song from the song list with the media-play button. As mpv takes over, the same key can be used to toggle play/pause in mpv.<p>"
                  "Other controls which work as usual are the touch pad as mouse replacement (if available) and the left and right mouse buttons.<br>"
                  "The cursor keys and the page up/down keys to navigate the combobox and song lists.<p>"
                  "Pop-up dialogs can be closed with the SPACE (current button) or RETURN (default button) keys. It's not always clear when the default button is not the current button.<br>"
                  "With TAB one can cycle through the widgets. However the visual feedback of the active widget is not (yet?) optimal.<p>"
                  "Right-click on a playlist combobox shows a menu. Either to edit the playlist (change songs order or drop a song) or (add-to playlist only) create/rename a playlist.<p>"
                  "Right-click on the selected song will show a menu to add it to the add-to playlist. As this is rather unprecise for me, SHIFT + F12 will do the same.<p>"
                  "<a href=""#Top"">back to top</a><p>"

                  "<hr>"
                  "<a name=""Configuration""><b><u>System configuration - Mpv, font size</u></b></a><p>"
                  "<b>Mpv</b><br>"
                  "If mpv is used as the media player, any song is shown according to mpv's default settings.<br>"
                  "The users mpv configuration file can be found under   /home/TheUser/.config/mpv/mpv.conf   .<br>"
                  "An small example configuration which shows videos full screen can look like this:<p>"
                  "force-window=yes<br>"
                  "fullscreen=yes<p>"
                  "The   'force-window=yes'   entry might be needed to show a black window while playing pure audio files. Without this you might hear the music but you cannot control mpv.<br>"
                  "See 'man mpv' or 'mpv --help' for more configuration information for mpv.<p>"
                  "As already mentioned, while mpv is running, it has the input focus and all of it's keyboard functions should work as expected. E. g. hit 'q' to quit the current song.<br>"
                  "This should make tlmb with mpv play nicely together with remote controls.<p>"
                  "<b>Font size</b><br>"
                  "When using tlmb as a player in an e. g. living room via a television, it might be neccessary to increase the font size above normal sizes.<br>"
                  "There is currently no program internal font adjustment in tlmb, as for stationary media players the font size adjustment might be required for all programs.<br>"
                  "tlmb uses Qt6. When using a window manager/desktop environment which does not natively sets the font size for programs which uses Qt via their system settings, qt6ct can be used to do so.<br>"
                  "Note, this will probably effect all Qt based programs!<br>"
                  "Install qt6ct, set and save the font size with it. In addition an environment variable has to be set, either per user or globally.<br>"
                  "To set it globally, add the line: QT_QPA_PLATFORMTHEME=qt6ct <br>"
                  "to the file: /etc/environment .<br>"
                  "Note, there exists the program - qt5ct - as well. This might also work, but then you may have to use - =qt5ct - in the line you add to /etc/environment .<p>"
                  "<a href=""#Top"">back to top</a><p>"

				  "<hr>"
                  "<a name=""Settings""><b><u>Program settings</u></b></a><p>"
				  "A settings dialog to set some program settings (sigh) can be opened by choosing Settings from the menu or hitting Ctrl+s.<br>"
				  "<b>Root directory</b><br>"
				  "The root directory holding all music files can be set here. This is intentionally done here, so the directory cannot be accidentally changed when using the remote control to navigate through the collection.<br>"
				  "<b>Start size</b><br>"
				  "Select how tlmb should be started: Fullscreen (usually overlapping any taskbar, Maximized (usually not overlapping any taskbar and dock) and in the last used position and size. The result of fullscreen and maximized may vary depending on your desktop environment/window manager, e. g. X11/wayland etc. .<br>"
				  "<b>Font</b><br>"
				  "Font type and size are currently not implemented, also the type is enabled (has no effect, sigh). See the configuration section on how to set the general font size for all Qt(6) applications.<br>"
				  "<b>Ind. icon size</b><br>"
				  "The size of the playing (blue note) and add-to (green plus) indicators, which should make it easier to see what is actually set for playing from and add songs to.<br>"
				  "<b>Play mode</b><br>"
				  "The play mode describes what tlmb should do after the end of a song:<br>"
				  " - Selected song only : nothing, you can and have to selected another song on your own.<br>"
				  " - To end of list : tlmb will play all songs following the calling one (not necessarily the first) until the end of the song list is reached.<br>"
				  " - Loop through song list : continuously playing the list, starting at the top again, when the end is reached.<br>"
				  "To break the continuous play when playing to the end of list or looping through it, press quit (q for mpv) again within the first 5 seconds of a new song.<br>"
				  "<b>Player</b><br>"
				  "Define up to 3 players and select the active one with the radiobutton. The first entry is for the player's executable and the second for any command line options.<br>"
				  "But you may want to specify the options rather unter the players original configuration file e.g.   ~/.config/playerX/foo.conf   .<p>"
                  "<a href=""#Top"">back to top</a><p>"

                  "<hr>"
                  "<a name=""Options""><b><u>Options</u></b></a><p>"
                  "There are no options to launch the program with.<p>"
                  "<a href=""#Top"">back to top</a><p>"

                  "<hr>"
                  "<a name=""Credits""><b><u>Credits</u></b></a><p>"
                  "tlmb is based on Qt6. It can use different music players.<p>"
                  "The program icon, slightly altered by me (some text removed, resized):<br>"
				  "- tlmb.svg - Gramophone.svg, openclipart.org, uploaded 2009-05-01 by Andy (Andrew Fritzsimon), Public Domain.<br>"
                  "Icons used within tlmb:<br>"
                  "- about.svg - CapA.svg, openclipart.org, uploaded 2016-04-03 by AdamStanislav, Public Domain.<br>"
                  "- down.svg - go-down-orange.svg, openclipart.org, uploaded 2012-01-09 by rygle, Public Domain.<br>"
				  "- drop.svg - blood-clipart.svg, openclipart.org, uploaded 2011-08-08 by prapanj, Public Domain.<br>"
                  "- edit.svg - Pencil-stylized-orange.svg, openclipart.org, uploaded 2011-08-31 by marcoqf73, Public Domain.<br>"
                  "- help.svg - open_icon_library-GPL-0.10, actions/help-contents-3.svg updated by H. Kortendieck (me).<br>"
                  "- music-note-blue.svg - 1339873253.svg, openclipart.org, uploaded 2012-06-16 by diamonjohn, Public Domain.<br>"
                  "- new.svg - matt-icons_document-add.svg, openclipart.org, uploaded 2015-01-10 by sixsixfive, Public Domain.<br>"
                  "- open.svg - actions/document-open-5.svg, open icon library version 2009-11-10, by tango (team), Public Domain.<br>"
                  "- plus-green.svg - tasto-2-architetto-franc-01-black-border.svg, openclipart.org, uploaded 2012-07-06 by kuba, Public Domain.<br>"
                  "- quit.svg - open_icon_library-GPL-0.10, actions/system-shutdown-6.svg .<br>"
                  "- rename.svg - tag.svg, openclipart.org, uploaded 2010-09-06 by jhnri4, Public Domain.<br>"
                  "- save-as.svg - actions/document-save-as-5.svg - open icon library version 10 Nov. 2009, oxygen,CC-BY-SA 3.0 or LGPL.<br>"
                  "- set.svg - pin.svg, openclipart.org, uploaded 2011-05-26 by gsagri04, Public Domain.<br>"
                  "- settings.svg - papapishu-Tools-1.svg, openclipart.org, uploaded 2007-12-28 by papapishu, Public Domain.<br>"
                  "- up.svg - go-up-orange.svg, openclipart.org, uploaded 2012-01-09 by rygle, Public Domain.<br>"
                  "Program and Documentation Copyright 2021-2025 Helge Kortendieck, alan@kasmithee.de .<br>"
                  "tlmb is released under the MIT license.<p>"
                  "<a href=""#Top"">back to top</a><p>"
                  "</body></html>");
	}
}
