/*********************************************************************
 *  SPDX-License-Identifier: MIT									 *
 *  Copyright (C) 2021-2025 by Helge Kortendieck  alan@kasmithee.de  *
 *                                                                   *
 *  This file is part of tlmb.                                       *
 *********************************************************************/

#ifndef _TLMB_H_
#define _TLMB_H_

#include <QAction>
#include <QApplication>
//#include <QByteArray>
#include <QCloseEvent>		//??
//#include <QDesktopWidget>	//??
#include <QDir>
#include <QHeaderView>
#include <QKeyCombination>
#include <QKeyEvent>
#include <QList>
#include <QMainWindow>
#include <QMediaMetaData>
#include <QMediaPlayer>
#include <QMenu>
#include <QMenuBar>
#include <QMessageBox>
#include <QPixmap>
#include <QPoint>
#include <QRect>
#include <QScreen>
#include <QSettings>
#include <QSize>
#include <QStatusBar>
#include <QString>
#include <QStringList>
#include <QTableWidget>
#include <QTableWidgetItem>
#include <QTimer>
#include <QToolBar>
#include <QWidget>
#include <QWindow>

#include "abouthelp.h"
#include "m3u.h"
#include "playerproc.h"
#include "playlistedit.h"
#include "playlistset.h"
#include "rw.h"
#include "settings.h"
#include "structs.h"

#include "ui_tlmb.h"

//#include <cstdlib>
#include <iostream>
using namespace std;

class Tlmb : public QMainWindow
{
	Q_OBJECT

public:
	Tlmb(QMainWindow *parent = 0);
		~Tlmb();

//void keyPressEvent(QKeyEvent *);

protected slots:
	void keyPressEvent(QKeyEvent *);

private:
    Ui::tlmb_ui uiTlmb;			// GUI

    bool bArtist;               // we found a readable Artist dir
	bool bD;
	bool bDuLS;					// bDupdLevelSong
	bool bMdHave;				// have meta data - whatever, song loaded successfully or was invalid
	bool bMdPlayer;				// qt media player to retrieve songs meta data from
    bool bMusicType;            // we found a readable music type dir
	bool bPlAddToPlay;			// bool false=play, true=add-to playlist
    bool bPlayer;				// player created true/false
    bool bPlaylistsArtist;      // have a 'playlists' dir in the currently selected artist directory
    bool bPlaylistsMusicType;   // have a 'playlists' dir in the currently selected music type directory
    bool bPlaylistsRoot;        // have a 'playlists' dir in the currently selected root directory
	bool bSucc;					// operation finished - 1 = successfully, 0 = error
	bool bQuit;					// flag whether we are quitting
	bool bSetDlgCreated;		// settings dialog created ?
	bool bStopPlaying;			// stop playing: true, do not play next song (break loop), false play next/first song - set to false after 5 seconds into a song

	int i;
	int i2;
    int iAddToPlCb;				// playlist combobox songs are added to: 'add to': 5=root dir, 6=music type, 7=artist/band
    int iAddToPlCbCurIdx;		// current index of add-to playlist in the iAddToPlCb combobox
	int iColWidth0;
	int iColWidth1;
	int iColWidth2;
    int iD;
	int iD2;
	int iD3;
	int iD4;
	int iErrLastSes;			// error re-creating last session
    int iFontSize;				// font size (pixels)
    int iIconSize;				// indicator icon size (pixels)
    int iLastCbPlAddTo;			// last playlist combobo add-to
    int iLastCbPlay;			// last combobox playing
//    int iM3uLevel;				// level of current m3u playlist: -1=undefined after boot, 0=root dir (allow all) 1=type dir (allow across current music type), 2=artist/band dir (allow only within this artist/band dir)
//    int iM3uLoaded;				// m3u playlist: -1=undefined after boot, 0=not available 1=writable but not yet loaded, 2=loaded into slM3u
	int iPlayer;				// 1-3, player defined in the settings dialog
    int iPlayers;				// available players, 1 = mpv (10=vlc, 11=both) - currently only mpv is supported)
    int iPlayCb;				// combobox music is played from: 1=Artist/Band, 2=Playlists root dir, 3=Playlists music typ, 4=Playlists Artist/band
	int iPlayMode;				// play mode: 1=single song, 2=to end of list, 3= loop through list
    int iPlCbCalled;			// context menu called from playlist combobox: playing: 2=root dir, 3=music type, 4=artist/band , add to: 5=root dir, 6=music type, 7=artist/band
    int iPlCbEditShown;			// playlist combobox the edit playlist widget is shown for: playing: 2=root dir, 3=music type, 4=artist/band , add to: 5=root dir, 6=music type, 7=artist/band
//	int iRep;					// -1 = add history item, >0 replace at iRep
	int iRet;					// return value of function (e. g. QMessageBox)
	int iScrX;					// screen width
	int iScrY;					// screen heigth
	int iSongCnt;				// number of songs in songs table widget
	int iSongCurIdx;			// index of current song in song list
	int iWShown;				// popup widget currently shown: 0=none, 1=about, 2=help, 3=settings dialog, 4=playing Pl edit, 5=add to Pl set, 6=add to Pl edit
	int iWToShow;				// popup widget to show: 0=none, 1=about, 2=help, 3=settings dialog, 4=playing Pl edit, 5=add to Pl set, 6=add to Pl edit
	int iX;						// cursor position for messagebox
	int iY;						// cursor position for messagebox
   
	QAction *actAbout;
	QAction *actExit;
	QAction *actHelp;

	QAction *actPlAddSong;		// add song to current playlist
	QAction *actPlEditShowW;	// show widget to edit current playlist
	QAction *actPlEditDeleteW;	// hide widget to edit current playlist
	QAction *actPlSetShowW;		// show widget to set current playlist
	QAction *actPlSetDeleteW;	// delete widget to set current playlist

	QAction *actSettings;

	QMediaMetaData mdData;
	QMediaPlayer *mdPlayer;

	QMenu *menuCbPlAddTo;			// right-click menu for playlist add to comboboxes
	QMenu *menuCbPlPlaying;			// right-click menu for playlist playing comboboxes
	QMenu *menuFile;				// file menu
	QMenu *menuHelp;				// help menu
	QMenu *menuTwSongsRightClick;	// right-click menu for songs table widget

	QPixmap pmPlaying;
	QPixmap pmPlAddTo;

	QPoint pPos;					// cursor position
	QPoint pPosD;					// cursor position
	QPoint pPosDel;					// cursor position

	QRect rFrame;					// frame geometry = screen size

	QString sAddToPl;				// current add-to playlist, name - find combobox (level) via iAddToPlCb, the other 2 are "", only 1 valid add-to playlist allowed
	QString sAddToPlFull;			// current add-to playlist, full path + name
    
    QString sD;						// dummy QString
	QString sD2;					// dummy QString
	QString sD3;					// dummy QString
//	QString sD4;					// dummy QString

    QString sLastArtist;			// last session artist, name
    QString sLastMusicType;			// last session music type, name
    QString sLastPlArtist;			// name of last session playlist in current artist dir
    QString sLastPlMusicType;		// name of last session playlist in current music type dir
    QString sLastPlRoot;			// name of last session playlist in root dir
    QString sLastAddToPl;			// name of last session add-to playlist

	QString sM3u;					// current playlist (to add to)

    QString sPathAllowedDir; 		// allowed dir path - depending which level we are in: music type=2, artist=3, song=4
    QString sPathAllowedPl;			// allowed playlist path - depending which playlist is meant - root, music type, artist: play or add-to

	QString	sPlayer;				// player command 
	QString sPlayerOptions;			// options for player command as text (needs to be separated into argument qstringlist)

	QString sPl;					// playlist name, either play or add-to - for common functions, e. g. call of edit playlist widget
	QString sPlPath;				// playlist path only, either play or add-to - for common functions, e. g. call of edit playlist widget

    QString sPlayArtist;			// current artist, name
    QString sPlayMusicType;			// current music type, name
    QString sPlayPl;				// current play playlist, name - "" if playing from artist dir
    QString sPlayPlFull;			// current play playlist, full path & name - "" if playing from artist dir
    QString sPlaySong;				// current song, full path and name - got from dir or from playlist struct list - hence cannot use playlist struct list directly
    
    QString sPlayPlArtist;			// name of current playlist in current artist dir
    QString sPlayPlMusicType;		// name of current playlist in current music type dir
    QString sPlayPlRoot;			// name of current playlist in root dir

	QString sRet;					// return QString
	QString sRootDir;              	// full path to current root directory
    QString sRootDirOld;           	// old full path to current root directory
    
	QString sSongsDir;				// full path n name of current songs dir, if not playlist
	
	QString sTT;					// tool tip text - short living

    QStringList slD;                // dummy QStringList
    
    QStringList slPlayerOptions;    // player options
    
    QStringList slPlArtist;			// list with playlists in selected artist/band directory, name
    QStringList slPlMusicType;		// list with playlists in selected music type directory, name
    QStringList slPlRoot;			// list with playlists in selected root directory, name
    
	QStringList slPlayArtists;		// list with artist/band directories in selected music type directory, full path n name
	QStringList slPlayMusicTypes;	// list with music type directories in root directory, full path n name
    QStringList slPlaySongs;		// list of songs, full path and name

	StrM3u strM3uD;					// playlist item struct entity
	QList<StrM3u> liM3uStr;			// list with songs in StrM3u items
	QList<StrM3u> liM3uStrAddTo;	// list with songs in StrM3u items of add-to playlist
	QList<StrM3u> liM3uStrPlay;		// list with songs in StrM3u items of playing playlist: root, music type or artist

	StrSong strSongD;				// song struct entity
	QList<StrSong> liSongStr;		// list with song structs for songs table widget

	QTableWidgetItem *twItemD;		// a QTableWidgetItem

	QTimer *timerSaveHeaderWidth;	// 5 sec timer to store resizing of column width of the qtablewidgets
	QTimer *timerStopPlayingDisable;// 5 sec timer to disable stop playing if quit playing a song within 5 sec when playing to end of list or looping through the song list

	QToolBar *toolBar;

	PlayerProc *playerProc;			// player qprocess

	aboutHelp *ahw;					// help widget
	EditPlayList *wPlEdit;			// edit playlist widget
	SetPlayList *wPlSet;			// set playlist widget
	setDlg *setDlgW;				// settings dialog

private slots:

	void createActions();					// create actions
	void createMenu();						// create menu
	void createMenuCbPlAddTo();				// right-click menu for playlist add to comboboxes
	void createMenuCbPlPlaying();			// right-click menu for playlist playing comboboxes
	void createMenuTwSongs();				// songs table widget right-click menu
	void createToolBar();					// create toolbar
//	void createStatusBar();					// create statusbar
//	void updStatusBar(const QString& sD);	// update statusbar

	void quitPrep();						// quit clicked clean up
	void quitDo();							// finally quit the program

	void cbAddToPlArtistChgd(int iD);						// current index of add-to artist combobox has changed
	void cbAddToPlArtistCon(bool bD);						// connect (true) / disconnect (false) add-to artist playlist combobox signals
	void cbAddToPlArtistEnable(bool bD);	         	  	// enable (true) / disable (false) artist add-to playlist combobox
	void cbAddToPlArtistMenuCalled(const QPoint& pPosD);	// right click in artist 'add to' playlist combo box - call context menu

	void cbAddToPlClearAll();								// clear all playlists add-to comboboxes, e. g. when new root dir
	void cbAddToPlMenuShow();								// show context menu for a 'add to' playlist combobox

	void cbAddToPlMusicTypeChgd(int iD);					// current index of add-to music type combobox has changed
	void cbAddToPlMusicTypeCon(bool bD);					// connect (true) / disconnect (false) add-to music type playlist combobox signals
	void cbAddToPlMusicTypeEnable(bool bD);	       	  	    // enable (true) / disable (false) music type add-to playlist combobox
	void cbAddToPlMusicTypeMenuCalled(const QPoint& pPosD);	// right click in music type 'add to' playlist combo box - call context menu

	void cbAddToPlRootChgd(int iD);							// current index of add-to root combobox has changed
	void cbAddToPlRootCon(bool bD);							// connect (true) / disconnect (false) add-to root playlist combobox signals
	void cbAddToPlRootEnable(bool bD);	         	  	    // enable (true) / disable (false) root add-to playlist combobox
	void cbAddToPlRootMenuCalled(const QPoint& pPosD);		// right click in root 'add to' playlist combo box - call context menu

	bool cbAddToPlSetCurrent();								// set current add-to playlist

	void cbDisableAll();								// disable and clear all comboboxes and set dir & name strings to ""
	void cbDisableArtist();								// disable and clear all artist comboboxes and set dir & name string to ""

	void cbIndicatorCreate();							// load and scale indicator icons
	void cbIndicatorPlayingClear();						// clear playing indicator for all 4 possible comboboxes
	void cbIndicatorPlayingSet();						// set playing indicator for combobox playing songs from
	void cbIndicatorPlAddToClear();						// clear current playlist indicator for all 3 possible playlist comboboxes
	void cbIndicatorPlAddToSet();						// set indicator for playlist combobox songs will be added to

	void cbPlPopArtist();								// populate artist playlists comboboxes - play and add-to
	void cbPlPopMusicType();							// populate music type playlists comboboxes - play and add-to
	void cbPlPopRoot();	                    	 		// populate root path playlists comboboxes - play and add-to
	void cbPlPopUpd(int iD);	               	 		// update playlist comboboxes for iAddToPlCB level - artists, music tyep, root

	void cbPlayArtistActivated(int iD);					// set combobox to play from to Artist/band, iCbPlaying = 1
	void cbPlayArtistChgd();							// artist combobox index changed
	void cbPlayArtistCon(bool bD);						// connect 1 / disconnect 0 artist/band combobox signals
	void cbPlayArtistClear();							// clear artist combobox
	void cbPlayArtistEnable(bool bD);					// enable (true) / disable (false) music type play playlist combobox
	void cbPlayArtistNone();							// no artists - disable all artists comboboxes and song widget
	void cbPlayArtistPop();								// populate artist combobox
	bool cbPlayArtistSetCurrent(const QString& sD);		// set current artist/band

	void cbPlayChgd();									// the combobox playing from has changed

	void cbPlayMusicTypeChgd();							// music type combobox index changed
	bool cbPlayMusicTypeChk();							// check for music type dirs in root dir - disable all if none
	void cbPlayMusicTypeClear();						// clear and disable music type combobox
	void cbPlayMusicTypeCon(bool bD);					// connect 1 / disconnect 0 music type combobox signals
	void cbPlayMusicTypeEnable(bool bD);				// enable (true) / disable (false) music type play playlist combobox
	void cbPlayMusicTypeNone();							// no music types - disable all relevant combo boxes
	void cbPlayMusicTypePop();							// populate music type combobox
	bool cbPlayMusicTypeSetCurrent(const QString& sD);	// set current music type

	void cbPlayPlArtistActivated(int iD);				// set combobox to play from to artist/band playlists, iCbPlaying = 4
	void cbPlayPlArtistChgd();							// play artist combobox index changed
	void cbPlayPlArtistClear();							// clear artist playlists combobox
	void cbPlayPlArtistCon(bool bD);					// connect 1 / disconnect 0 artist/band playlist combobox signals
	void cbPlayPlArtistEnable(bool bD);					// enable (true) / disable (false) artist play playlist combobox
	void cbPlayPlArtistMenuCalled(const QPoint& pPosD);	// right click in artist playing playlist combo box - call context menu
	bool cbPlayPlArtistSetCurrent(const QString& sD);	// set current artist/band playlist

	void cbPlayPlMenuShow();							// show context menu for a playing playlist combobox

	void cbPlayPlMusicTypeActivated(int iD);				// set combobox to play from to music type playlists, iCbPlaying = 3
	void cbPlayPlMusicTypeChgd();							// play music type combobox index changed
	void cbPlayPlMusicTypeClear();							// clear and disable music type playlists combobox
	void cbPlayPlMusicTypeCon(bool bD);						// connect 1 / disconnect 0 music type playlist combobox signals
	void cbPlayPlMusicTypeEnable(bool bD);					// enable (true) / disable (false) music type play playlists combobox
	void cbPlayPlMusicTypeMenuCalled(const QPoint& pPosD);	// right click in music type playing playlist combo box - call context menu
	bool cbPlayPlMusicTypeSetCurrent(const QString& sD);	// set current music type playlist

	void cbPlayPlRootActivated(int iD);					// set combobox to play from to root playlists, iCbPlaying = 2
	void cbPlayPlRootChgd();							// play root combobox index changed
	void cbPlayPlRootCon(bool bD);						// connect 1 / disconnect 0 root playlist combobox signals
	void cbPlayPlRootEnable(bool bD);	           	    // enable (true) / disable (false) root play playlists combobox
	void cbPlayPlRootMenuCalled(const QPoint& pPosD);	// right click in root playing playlist combo box - call context menu
	bool cbPlayPlRootSetCurrent(const QString& sD);		// set current root play playlist

	void cbPlaySet();									// set current playing from combobox

	int cbPop();										// populate all comboboxes - 0=success, 1=failure
	
	void customMenusCon(bool bD);						// connect 1 / disconnect 0 custom menus
	void customMenusSetPolicy();						// set context menu policy for widgets with custom context menu

	bool dirArtistChgd();								// artist dir has changed - try re-loading artist playlists and songs in dir
	bool dirArtistChk();								// check if artist dir is valid: exists, readable and has artist dirs
	bool dirMusicTypeChgd();							// music type dir has changed - try re-loading music playlists, artist dir and it's playlists and songs in artist dir
	bool dirMusicTypeChk();								// check if music type dir is valid: exists, readable and has music types dirs
	bool dirRootChgd();									// root dir has changed - try re-loading music types and root playlists
	bool dirRootChk();									// check if root dir is valid: exists, readable and has music type dirs

	void metadataGet();												// get meta data from song
	void metadataPlayerCreate();									// create qt media player only to retrieve songs meta data from it
	void metadataPlayerStatusChgd(QMediaPlayer::MediaStatus state);	// mdPlayer: media status changed - needed just to retrieve meta data?
	void metadataPlayerDelete();									// delete qt media player (only used to retrieve meta data from song)
	
	QString pathGetAllowedDir(int iD);					// get allowed directory path depending which level we are in: music type=2, artist=3, song=4
	QString pathGetAllowedPl(int iD);					// get allowed playlist file depending which level the playlist is in: play: root=2, music type=3, artist=4 ; add-to: root=5, music type=6, artist=7

	void playerCreate();								// create player qprocess, once at program start
	void playerDisableStop();		           			// disable to stop automatically playing next song when playing to end of list or looping through it
	void playerEnded(int iD);							// player qprocess ended - 0=normal, 1=crashed
	void playerAvail(bool bD);							// receive result of checking if player is available
	void playerStart();                                 // start player qprocess

	void plAddToAddSong();								// add current song to current add to playlist
	void plAddToAddSongFinish();						// finish add current song to current add-to playlist - media has been loaded, chance to extract meta data
	bool plAddToLoad();									// load add-to playlist as StrM3u list
	void plAddToSetNew(const QString& sD);				// add to playlist has changed - set new playlist to add songs to - sD = name only, also from playlistset widget
	void plAddToSetPathName();							// set sAddToPlFull - full path and name of current add-to playlist
	bool plLoad(bool bD, const QString& sD);			// load a m3u playlist - return true success, false error on open , call false=play true=add-to
	bool plPlayLoad();									// load play playlist as StrM3u list
	void plPlayUpd(const QList<StrM3u>& liM3uStr);		// current playing playlist has been updated - re-load song list
	bool plWrite(const QString& sD, const QList<StrM3u>& liM3uStr);	// save playlist - full path & name, m3u struct list

	bool twSongsChk();									// check whether the selected comboboxes lead to songs to show
	void twSongsCellActivated(int iD, int iD2);			// cell in table widget activated (clicked) (row, col)
	void twSongsCellDoubleClicked(int iD, int iD2);		// cell in table widget double clicked (row, col) - play song
	void twSongsClear();								// clear table widget songs
	void twSongsCon(bool bD);							// connect (true) / disconnect (false) songs table widget signals
	void twSongsCurrentCellChgd(int iD, int iD2, int iD3, int iD4);	// current cell changed - set (new?) row index
	void twSongsHeaderSet();							// set table widget songs header
	void twSongsList2StrList();							// create list with song struct from list of playable songs (this list can come from rw.cpp or m3u.cpp - so do it here once)
	void twSongsMenuCalled(const QPoint& pPosD);		// right click in table widget songs - call context menu
	void twSongsPop();									// populate songs widget
	void twSongsRightClickMenuCreate(int iD);			// create songs table widget right click menus - iD = category

	void init();										// starting up

	int mbShow(int iD, const QString& sD, const QString& sD2, const QString& sD3, const QString& sD4, const QString& sD5);
	                                // show QMessageBox at cursor position, 1=Info, 2=Warning, 3=Critical, 4=Question, 5=Question yes/no/cancel
	                                // iD=type, sD=title, sD2=text, sD3=accept button text, sD4=reject button text, sD5=destructive button text (no but continue)
	void mbTxt_AddToPlAddSongExists();					// show message box - songs already exists in add-to playlist
	void mbTxt_AddToPlAddSongFailed();					// show message box - failed to write updated add-to playlist
	void mbTxt_AddToPlAddSongSuccess();					// show message box - song added to add-to playlist
	void mbTxt_AddToPlNotFound();						// show message box - the (last) add-to playlist could not be found
	void mbTxt_ArtistNoneFound();						// show message box - no artist/band found
	void mbTxt_MusicTypeNoneFound();					// show message box - no music type found
	void mbTxt_PathRootInvalid();						// show message box - root directory invalid
	void mbTxt_PlLoadError(const QString& sD3, const QString& sD);	// show message box - could not read playlist - sD3 = play or add-to , sD = playlist full path & name
	void mbTxt_PlayerNoneDefined();						// show message box - no player defined
	void mbTxt_PlayerNoneFound();						// show message box - no supported player found
	void mbTxt_WPlEditEmpty();							// show message box - empty playlist - no need to open edit window
	void mbTxt_WPlEditFailed();							// show message box - error - failed to save changes to playlist
	void mbTxt_WPlEditSuccess();						// show message box - success - changes to playlist saved

	bool sessionLastReCreate();					// try re-creating last session settings - true/1 = success

    void setDlgShow();                          // create and show settings dialog
    void setDlgClosed(bool bD);                 // settings dialog was closed, delete it and react to changes

	void settingsRead();
	void settingsWrite();

	void timersCreate();						// create all timers
	void timerSaveHeaderWidthStart();			// start timer to save header width of all qtablewidgets
	void timerStopPlayingDisableStart();		// start timer to disable to stop playing next song in loop from a) playing to end and b) loop through list

	bool updLevelArtist(bool bD);				// update artist level widgets, true= try enable, false=disable always: play combobox, play playlists combobox and add-to playlists combobox
	bool updLevelMusicType();					// update music type level widgets: play, play playlists and add-to playlists comboboxes
	bool updLevelRoot();						// update root level widgets, play and add-to playlists comboboxes
	bool updLevelSong(bool bD);					// update songs level widgets, true= try enable, false=disable always: well, actually just the song table widget

	void wAddToPlSetDelete();					// delete set playlist widget
	void wAddToPlSetNew(const QString& sD, bool bD);	// set new add-to playlist according to settings from the set add-to playlist widget
	void wAddToPlSetShow();						// show set playlist widget

	void wAhShowAbout();						// show about information
	void wAhShowHelp();							// show help message
	void wAhCreate();							// create about/help/error dialog widget
	void wAhDel();								// hide=delete later about/help dialog widget

	void wCtrl(int iWToShow); 					// show popup widget, if no other is shown: 0=none, 1=about, 2=help, 3=settings dialog, 4=playing Pl edit, 5=add to Pl set, 6=add to Pl edit
	void wMainFocusSet();						// set focus (back) to main widget or if possible to song tablewidget

	void wPlEditApply(const QList<StrM3u>& liM3uStr);	// return from the edit playlist widget - apply any changes
	void wPlEditDelete();								// delete edit playlist widget - playing and add-to
	void wPlEditShow();									// show edit playlist widget - playing and add-to


	signals:
		void sigTlmbAhwShow(int iD);																		// show info dlg: about, help
		void sigTlmbPlayerChkAvail(const QString& sD, const QStringList& slD);								// check if player sD can be found - player sD and player options slD
		void sigTlmbPlayerStart(const QString& sD);															// start qprocess to play song
		void sigTlmbPlEditShow(const QString& sD, const QString& sD2, const QList<StrM3u>& sLiM3uItems);	// send current playlist to playlist widget - sD=allowed path,
		void sigTlmbPlSetShow(const QString& sD, const QString& sD2);										// send full path n name of current playlist to set playlist widget - sD=allowed path,
		void sigTlmbSetShow();																				// show settings dialog
};

#endif 
