/*********************************************************************
 *  SPDX-License-Identifier: MIT									 *
 *  Copyright (C) 2021-2023 by Helge Kortendieck  alan@kasmithee.de  *
 *                                                                   *
 *  This file is part of tlmb.                                       *
 *********************************************************************/

#ifndef _SETTINGS_H_
#define _SETTINGS_H_

#include <QCheckBox>
#include <QDialog>
#include <QDir>
#include <QFileDialog>
#include <QFileInfo>
#include <QFont>
#include <QMessageBox>
#include <QPoint>
#include <QPushButton>
#include <QRadioButton>
#include <QSettings>
#include <QSize>
#include <QString>
#include <QWidget>

#include "ui_settings.h"

#include <iostream>
using namespace std;

class setDlg : public QDialog
{
	Q_OBJECT

public:
	setDlg(QDialog* parent = 0, Qt::WindowFlags fl = Qt::Dialog);
		~setDlg();

private:
	bool bCanceled;			// settings dialog was canceled
	bool bsD;				// shall main program re-read it settings, any changes?
	bool bSaveEnabled;		// debugging pb_Save->setEnabled(true) triggers the button?

	int sdiD;

	QPoint sSetPos;			// dialog position, top left corner

	QSize sSetSize;			// dialog size

	QString sRootDir;		// root dir (needed to check for valid directory)

    Ui::dlgSet_ui uiDlgSet;	// settings widget

    QDialog wDlgSet;		// settings widget

private slots:
	void dlgShow();			// show dialog
	void dlgEnableSave();	// enable save button
	void dlgClose();		// close dialog
	void rootDirChk();			// check if root directory is valid
	void rootDirDlgClicked();	// button to set root directory clicked
//	void rootDirEditFin();		// manually setting the root directory finished
	void rootDirSet();			// set the programs root directory
	void setRead();			// read settings
	void setWrite();		// write settings

//	void setWritePosSize();	// write settings, widget pos and size
//	void dlgSave();			// save settings

	signals:
		void sigReReadSet(bool);	// signal main program to re-read settings, bool whether re-read settings
};

#endif
