/*********************************************************************
 *  SPDX-License-Identifier: MIT									 *
 *  Copyright (C) 2021-2025 by Helge Kortendieck  alan@kasmithee.de  *
 *                                                                   *
 *  This file is part of tlmb.                                       *
 *********************************************************************/

#include "settings.h"

setDlg::setDlg(QDialog* parent, Qt::WindowFlags fl)
	: QDialog(parent, fl)
{
    uiDlgSet.setupUi(&wDlgSet);
}

setDlg::~setDlg()
{
}

void setDlg::setRead()
{
	QSettings settings("tlmb", "tlmb");

	settings.beginGroup("settingsDlg");
        wDlgSet.resize(settings.value("size", QSize(330, 550)).toSize());						// settings dialog position and size
        wDlgSet.move(settings.value("pos", QPoint(0, 0)).toPoint());
        uiDlgSet.dlgSet_l_rootDir->setText(settings.value("rootdir", "/tlmb").toString());      // path to music collection's root directory
        if (settings.value("startFullScreen", true).toBool() == true) {							// how shall we start: fullscreen, maximized, last size
			uiDlgSet.dlgSet_rb_FullScreen->setChecked(true);
		} else if (settings.value("startMaximized", false).toBool() == true) {
			uiDlgSet.dlgSet_rb_Maximized->setChecked(true);
		} else if (settings.value("startLastSize", false).toBool() == true) {
			uiDlgSet.dlgSet_rb_LastSize->setChecked(true);
		}
//		uis.fcb_Font = settings.value("fontname", "").toString();								// font name only for the combo boxes and the song list
		uiDlgSet.dlgSet_sb_FontSize->setValue(settings.value("fontSize", 12).toInt());			// font size only for the combo boxes and the song list
		uiDlgSet.dlgSet_sb_IconSize->setValue(settings.value("iconSize", 24).toInt());			// size for indicator icons, 8-128, default=24

		sdiD = settings.value("playMode", 1).toInt();											//play mode: 1=single song, 2=to end of list, 3=loop through list
        switch (sdiD) {
			case 1:
			    uiDlgSet.dlgSet_rb_SelectedSong->setChecked(true);
			    break;
			case 2:
			    uiDlgSet.dlgSet_rb_ToEnd->setChecked(true);
			    break;
			case 3:
			    uiDlgSet.dlgSet_rb_Loop->setChecked(true);
			    break;
		}

		sdiD = settings.value("player", 1).toInt();												//play mode: 1=player 1, 2=player 2, 3=player 3
        switch (sdiD) {
			case 1:
			    uiDlgSet.dlgSet_rb_Player1->setChecked(true);
			    break;
			case 2:
			    uiDlgSet.dlgSet_rb_Player2->setChecked(true);
			    break;
			case 3:
			    uiDlgSet.dlgSet_rb_Player3->setChecked(true);
			    break;
		}

		uiDlgSet.dlgSet_le_Player1->setText(settings.value("player1", "").toString());   				// player 1 command
		uiDlgSet.dlgSet_le_Player1Options->setText(settings.value("player1Options", "").toString());   	// player 1 options
		uiDlgSet.dlgSet_le_Player2->setText(settings.value("player2", "").toString());   				// player 2 command
		uiDlgSet.dlgSet_le_Player2Options->setText(settings.value("player2Options", "").toString());   	// player 2 options
		uiDlgSet.dlgSet_le_Player3->setText(settings.value("player3", "").toString());   				// player 3 command
		uiDlgSet.dlgSet_le_Player3Options->setText(settings.value("player3Options", "").toString());   	// player 3 options

//		uis.cB_ShowFitToScreen->setChecked(settings.value("showfittoscreen", "true").toBool());		// 0=orig size, 1=fit to screen

	settings.endGroup();
}

void setDlg::setWrite()
{
	QSettings settings("tlmb", "tlmb");

	settings.beginGroup("settingsDlg");
		settings.setValue("pos", pos());
		settings.setValue("size", size());
		if (bSaveEnabled == true) {
            settings.setValue("rootdir", uiDlgSet.dlgSet_l_rootDir->text());
            settings.setValue("startFullScreen", uiDlgSet.dlgSet_rb_FullScreen->isChecked());
            settings.setValue("startMaximized", uiDlgSet.dlgSet_rb_Maximized->isChecked());
            settings.setValue("startLastSize", uiDlgSet.dlgSet_rb_LastSize->isChecked());			// size and position of tlmb are stored in tlmb
//			settings.setValue("fontname", uis.fcb_Font->text());
			settings.setValue("fontSize", uiDlgSet.dlgSet_sb_FontSize->value());					// font size for combo boxes and the song list
			settings.setValue("iconSize", uiDlgSet.dlgSet_sb_IconSize->value());					// size for indicator icons
			if (uiDlgSet.dlgSet_rb_SelectedSong->isChecked() == true) {								//play mode: 1=single song, 2=to end of list, 3=loop through list
				settings.setValue("playMode", 1);
			} else if (uiDlgSet.dlgSet_rb_ToEnd->isChecked() == true) {
				settings.setValue("playMode", 2);
			} else if (uiDlgSet.dlgSet_rb_Loop->isChecked() == true) {
				settings.setValue("playMode", 3);
			}
			if (uiDlgSet.dlgSet_rb_Player1->isChecked() == true) {									//player to use: 1=player 1, 2=player 2, 3=player 3
				settings.setValue("player", 1);
			} else if (uiDlgSet.dlgSet_rb_Player2->isChecked() == true) {
				settings.setValue("player", 2);
			} else if (uiDlgSet.dlgSet_rb_Player3->isChecked() == true) {
				settings.setValue("player", 3);
			}
			settings.setValue("player1", uiDlgSet.dlgSet_le_Player1->text());
			settings.setValue("player1Options", uiDlgSet.dlgSet_le_Player1Options->text());
			settings.setValue("player2", uiDlgSet.dlgSet_le_Player2->text());
			settings.setValue("player2Options", uiDlgSet.dlgSet_le_Player2Options->text());
			settings.setValue("player3", uiDlgSet.dlgSet_le_Player3->text());
			settings.setValue("player3Options", uiDlgSet.dlgSet_le_Player3Options->text());
		}
	settings.endGroup();

	settings.sync();
}

void setDlg::dlgShow()
{
	setRead();

    uiDlgSet.dlgSet_pb_fileDlgOpen->setIcon(QIcon("/usr/share/tlmb/icons/scalable/open.svg"));

	connect(uiDlgSet.dlgSet_rb_FullScreen, SIGNAL(toggled(bool)), this, SLOT(dlgEnableSave()));
    connect(uiDlgSet.dlgSet_rb_Maximized, SIGNAL(toggled(bool)), this, SLOT(dlgEnableSave()));
    connect(uiDlgSet.dlgSet_rb_LastSize, SIGNAL(toggled(bool)), this, SLOT(dlgEnableSave()));
    connect(uiDlgSet.dlgSet_sb_FontSize, SIGNAL(valueChanged(int)), this, SLOT(dlgEnableSave()));
    connect(uiDlgSet.dlgSet_sb_IconSize, SIGNAL(valueChanged(int)), this, SLOT(dlgEnableSave()));
    connect(uiDlgSet.dlgSet_rb_SelectedSong, SIGNAL(toggled(bool)), this, SLOT(dlgEnableSave()));
    connect(uiDlgSet.dlgSet_rb_ToEnd, SIGNAL(toggled(bool)), this, SLOT(dlgEnableSave()));
    connect(uiDlgSet.dlgSet_rb_Loop, SIGNAL(toggled(bool)), this, SLOT(dlgEnableSave()));
    connect(uiDlgSet.dlgSet_pb_fileDlgOpen, SIGNAL(clicked()), this, SLOT(rootDirDlgClicked()));
    connect(uiDlgSet.dlgSet_pb_cancel, SIGNAL(clicked()), this, SLOT(dlgClose()));
    connect(uiDlgSet.dlgSet_pb_save, SIGNAL(clicked()), this, SLOT(dlgClose()));
    connect(uiDlgSet.dlgSet_rb_Player1, SIGNAL(toggled(bool)), this, SLOT(dlgEnableSave()));
    connect(uiDlgSet.dlgSet_rb_Player2, SIGNAL(toggled(bool)), this, SLOT(dlgEnableSave()));
    connect(uiDlgSet.dlgSet_rb_Player3, SIGNAL(toggled(bool)), this, SLOT(dlgEnableSave()));
    connect(uiDlgSet.dlgSet_le_Player1, SIGNAL(editingFinished()), this, SLOT(dlgEnableSave()));
    connect(uiDlgSet.dlgSet_le_Player1Options, SIGNAL(editingFinished()), this, SLOT(dlgEnableSave()));
    connect(uiDlgSet.dlgSet_le_Player2, SIGNAL(editingFinished()), this, SLOT(dlgEnableSave()));
    connect(uiDlgSet.dlgSet_le_Player2Options, SIGNAL(editingFinished()), this, SLOT(dlgEnableSave()));
    connect(uiDlgSet.dlgSet_le_Player3, SIGNAL(editingFinished()), this, SLOT(dlgEnableSave()));
    connect(uiDlgSet.dlgSet_le_Player3Options, SIGNAL(editingFinished()), this, SLOT(dlgEnableSave()));

	bsD = false;
	bSaveEnabled = false;
//cout << "dlgShow reached " << endl;
    wDlgSet.show();
}

void setDlg::dlgEnableSave()                // enable save (button)
{
	bsD = true;
	bSaveEnabled = true;
	uiDlgSet.dlgSet_pb_save->setEnabled(true);

//cout << "dlgEnableSave at end " << endl;
}

void setDlg::dlgClose()                     // close settings dialog
{
	setWrite();
//	if (bSaveEnabled == true) {
		emit sigReReadSet(bsD);
//	}
    wDlgSet.hide();
}

/*
void setDlg::rootDirEditFin()				// manually setting the root directory finished
{
    sRootDir = uiDlgSet.dlgSet_l_rootDir->text();
	if (sRootDir.right(1) == "/") {				// delete closing '/' if it exists
		sRootDir.chop(1);
	}
	rootDirSet();
}
*/
void setDlg::rootDirDlgClicked()			// button to set root directory clicked
{
    sRootDir = uiDlgSet.dlgSet_l_rootDir->text();				//
	rootDirChk();

	sRootDir = QFileDialog::getExistingDirectory(this, tr("Select tlmb's start directory"),
                                                sRootDir,
                                                QFileDialog::ShowDirsOnly);					// | QFileDialog::DontResolveSymlinks);
	rootDirSet();
}

void setDlg::rootDirSet()						// set the programs root directory
{
	rootDirChk();
	
//	disconnect(uis.le_RootDir, SIGNAL(editingFinished()), this, SLOT(rootDirEditFin()));
cout << "rootDirSet after disconnect " << endl;
    uiDlgSet.dlgSet_l_rootDir->setText(sRootDir);
cout << "rootDirSet after setText " << endl;
//	connect(uis.le_RootDir, SIGNAL(editingFinished()), this, SLOT(rootDirEditFin()));
cout << "rootDirSet after connect " << endl;
	
	dlgEnableSave();
}


void setDlg::rootDirChk()					// check if root directory is valid
{
	QFileInfo finf(sRootDir);
	if (finf.isDir() == false or finf.isReadable() == false ) {
		QMessageBox::information(this, tr("tlmb information - directory invalid !"), 
									   tr("Attention, the entered/selected directory is invalid.\n"
										  "It either does not exist or it is not readable.\n"
										  "The directory will be set to your home directory."));
		sRootDir = QDir::homePath();																// invalid directory - set root dir to user home path
	}
}
