/*********************************************************************
 *  SPDX-License-Identifier: MIT									 *
 *  Copyright (C) 2021-2023 by Helge Kortendieck  alan@kasmithee.de  *
 *                                                                   *
 *  This file is part of tlmb.                                       *
 *********************************************************************/

#ifndef _RW_H_
#define _RW_H_

//#include "structs.h"

#include <QDir>
#include <QFile>
#include <QFileInfo>
#include <QList>
#include <QObject>
#include <QString>
#include <QStringList>
#include <QTextStream>

#include "structs.h"

// ******  debug  *****
#include <iostream>
using namespace std;


    int rwStatus(const QString& sRwD);                                  // check status: -1=does not exist, 100=dir/000=file, +10=readable, +1=writable

    QStringList rwGetListDirs(const QString& sRwD);                     // get list of readable dirs excluding 'playlists' and any 'ignore*' dir
    QStringList rwGetListPlaylists(const QString& sRwD);                // get list of readable playlists in given directory
    QStringList rwGetListSongs(const QString& sRwD);                    // get list of readable songs in given directory
    
//    bool rwDirHasPlaylists(const QString& sRwD);                            // 1=there is a playlists directory in the current directory

//    int rwFileStatus(const QString& sRwD);                                  // check file status: 0=does not exist, 100=dir, +10=readable, +1=writable
//    QStringList rwFileGetList(const QString& sRwD);                         // get list of readable files

//    int rwCommonFileStatus(const QString& sRwD);							// check file status: 0=does not exists, 1=dir, 2=file, +4=readable, +8=writable
/*	bool rwCommonFileDelete(const QString& sRwD3);							// delete file
	bool rwCommonFileReName(const QString& sRwD3, const QString& sRwD4);	// rename file type: sRwD3=old, sRwD4=new
	QStringList rwFileChkSave(const QString& sRwD);							// check save file, full path+name
	QStringList rwFileChkSaveAs(const QString& sRwD);						// check save file as, full path+name

	int rwCommonBackupCreate(const QString& sRwD2);					// create a backup before writing the current file (overwrite existing backup), -1=undefined, 0=OK, 11=not writable, 21=bak2 still exist=previous error, 31=bak to bak2 failed, 41=file to bak failed, 51=bak2 to bak failed, 61=del bak2 failed
	QString rwBackupErrorTxt(int iRwD, const QString& sRwD4);		// return a human readable error message from given error code

	QList<StrDomain> rwDomainFileOpen(const QString& sRwD);			// open domain list file

	QList<StrDomain> rwDomainSetupList(const QStringList& slRwD);	// setup the domain list from the file read, separate entries

	QStringList rwDomainFileSave(const QString& sRwD, const QList<StrDomain>& liRwDomainsD);	// save domain list (full path+name, domain list struct), create backup first
	bool rwDomainFileWrite(const QString& sRwD, const QList<StrDomain>& liRwDomainsD);			// write domain list file, full path+name & domain list

	QStringList rwUnboundFileSave(const QString& sRwD, const QList<StrDomain>& liRwDomainsD);	// save unbound blacklist conf file (full path+name, domain list struct), create backup first
	bool rwUnboundFileWrite(const QString& sRwD, const QList<StrDomain>& liRwDomainsD);			// write unbound blacklist conf file
*/
#endif
