/*********************************************************************
 *  SPDX-License-Identifier: MIT                                     *
 *  Copyright (C) 2022-2023 by Helge Kortendieck  alan@kasmithee.de  *
 *                                                                   *
 *  This file is part of tlmb.                                       *
 *********************************************************************/

#ifndef _PLAYLISTSET_H_
#define _PLAYLISTSET_H_

#include <QDialog>
#include <QDir>
#include <QFileDialog>
#include <QFileInfo>
#include <QMessageBox>
#include <QString>
#include <QTimer>
#include <QWidget>

#include "ui_playlistset.h"

#include "m3u.h"

#include <iostream>
using namespace std;


class SetPlayList : public QDialog
{
	Q_OBJECT

public:
	SetPlayList(QDialog* parent = 0);
		~SetPlayList();

private:
	bool bSplD;
	bool bSplCreateNew;

	int iSplD;
	int iSplD2;
	int iSplRet;

	QString sSplD;
	QString sSplD2;
	QString sSplFileFromDlg;
	QString sSplFileName;			// playlist name excl. .m3u ending
	QString sSplFileNameOld;
	QString sSplFilePath;
	QString sSplFilePathName;		// incl. /playlists
	QString sSplFilePathNameCalled;	// excl. /playlists
	QString sSplPathAllowed;		// here ending on .../playlists

	QStringList slSplD;
	QStringList slDSl;		// song list struct entity

	Ui::wSetPlayList uiSpl;	// set playlist widget

	QDialog wSpl;			// set playlist widget

private slots:
	bool splPlDirChk();								// check if .../playlists directory exists
	bool splPlDirCreate();							// ask to create .../playlists directory and eventually do

	void splDlgClose();												// close dialog
	void splDlgPopPathName();										// set playlist path and name in dialog
	void splDlgSetNew();											// set new m3u
	void splDlgShow(const QString& sSplD, const QString& sSplD2);	// show set playlist dialog

	void splFileCurChngd();							// current m3u changed
	void splFileNew();								// create new playlist to add files to
	int splFileNewCreate();							// physically create new playlist to add files to - 0=fail, 1=success
	void splFileRename();							// rename current playlist
	void splFileSaveAs();							// save current playlist under different name and start using it as such

	void splQmb(int iD);							// QMessageBox
	int splQmbQ(int iD);							// QMessageBox question

	signals:
		void sigSplTlmbM3uUpd(const QString& sSplD, bool bSplD);
		void sigSplTlmbDelete();
};

#endif
