/*********************************************************************
 *  SPDX-License-Identifier: MIT                                     *
 *  Copyright (C) 2014-2023 by Helge Kortendieck  alan@kasmithee.de  *
 *                                                                   *
 *  This file is part of tlmb.                               		 *
 *********************************************************************/

#ifndef _PLAYLISTEDIT_H_
#define _PLAYLISTEDIT_H_

#include <QDialog>
#include <QList>
#include <QListWidget>
#include <QListWidgetItem>
#include <QMessageBox>
//#include <QPoint>
#include <QString>
#include <QWidget>

#include "ui_playlistedit.h"

#include "m3u.h"
#include "structs.h"

#include <iostream>
using namespace std;

class EditPlayList : public QDialog
{
	Q_OBJECT

public:
	EditPlayList(QDialog* parent = 0);
		~EditPlayList();

private:
	int epliD;
	int epliD2;
	int epliCount;
	int epliRet;

	QString eplsD;
	QString eplsD2;

	QStringList slEplD;		// song list struct entity
//	SongList slDSl;			// song list struct entity

	Ui::wPlayList uiEpl;			// song list widget

	QDialog wEpl;			// song list widget

//	QPoint qPos;
	
	StrM3u eplStrM3uD;			// playlist item struct entity
	QList<StrM3u> eplLiItems;	// list with songs in StrM3u items
	QList<StrM3u> eplLiItemsD;	// list with songs in StrM3u items

private slots:
	void eplDlgApply();		// close dialog - apply changes to playlist
	void eplDlgCancel();	// close dialog - no updates to playlist
	void eplDlgPop();		// populate list widget with songs
	void eplDlgShow(const QString& eplsD, const QString& eplsD2, const QList<StrM3u>& eplLiItemsD);	// show edit playlist dialog - allowed path, path n name of m3u, m3u struct list
	void eplSongDown();		// move selected song down by 1 position
	void eplSongDrop();		// drop selected song from playlist
	void eplSongUp();		// move selected song up by 1 position

	signals:
		void sigEplTlmbM3uUpd(const QList<StrM3u>& eplLiItemsD);
		void sigEplTlmbDelete();
};

#endif
