/*********************************************************************
 *  SPDX-License-Identifier: MIT									 *
 *  Copyright (C) 2023-2025 by Helge Kortendieck  alan@kasmithee.de	 *
 *                                                                   *
 *  This file is part of tlmb.                                       *
 *********************************************************************/

#ifndef _PLAYERPROC_H_
#define _PLAYERPROC_H_

#include <QByteArray>
#include <QDateTime>
#include <QFileInfo>
#include <QObject>
#include <QProcess>
#include <QString>

#include <iostream>
using namespace std;

class PlayerProc : public QObject
{
  Q_OBJECT

public:
	PlayerProc(QObject *parent = 0);
		~PlayerProc();

private:
	bool bPlaying;				// track player qprocess running
	bool bPpD;

	int iPpD;
	int iPpD2;

	QByteArray aOutput;			// stdout qprocess

	QProcess *ppPlayerProc;		// detached player qprocess

	QString sPpCmd;				// player command for qprocess
	QString sPpD;
	QString sPpFile;
	QString sPpIn;				// input line from player qprocess output
	QString sPpCmdLine;			// player command line

	QStringList slPpD;			// dummy
	QStringList slPpOps;		// player options
	QStringList slPpProcArgs;	// qprocess argument(s)

private slots:
	void ppChkAvail(const QString& sPpD, const QStringList& slPpD);	// check if player sD can be found - slD=player options

	void ppProcPrep(const QString& sPpD);	// prepare player - full path n name of file to play
	void ppProcStart();						// start rsync qprocess
	void ppProcExit(int iD, QProcess::ExitStatus iPpD2);	// player process has exited, 0=normal, 1=crash
	void ppProcReadStdErr();				// read error output from player process
	void ppProcReadStdOut();				// read output from player process

	signals:
		void sigPpChkEnd(bool bPpD);		// send whether player could be found
		void sigPpExited(int iPpD);			// player process exited: 0 = normally, 1 = unexpected/crash
};

#endif // _PLAYERPROC_H_
