/*********************************************************************
 *  SPDX-License-Identifier: MIT									 *
 *  Copyright (C) 2023-2025 by Helge Kortendieck  alan@kasmithee.de	 *
 *                                                                   *
 *  run detached process with external media player                  *
 *  currently only mpv is supported (vlc may be later)               *
 *                                                                   *
 *  This file is part of tlmb.                                       *
 *********************************************************************/

#include "playerproc.h"


PlayerProc::PlayerProc( QObject *parent ) : QObject( parent)
{
	bPlaying = false;
}

PlayerProc::~PlayerProc()
{
}

void PlayerProc::ppChkAvail(const QString& sPpD, const QStringList& slPpD)	// check if player sPpD can be found - slPpD=player options
{
	sPpCmd = sPpD;
	slPpOps = slPpD;

	QFileInfo qfi(sPpCmd);
	if (qfi.exists() == true) {
		bPpD = true;
	} else if (sPpCmd.left(9) == "/usr/bin/") {
		bPpD = false;
	} else {											// player was defined without path, add it
		sPpCmd = "/usr/bin/" + sPpCmd;
		QFileInfo qfi(sPpCmd);
		if (qfi.exists() == true) {
			bPpD = true;
		} else {
			bPpD = false;
		}
	}

//cout << "ppChkAvail reached " << sPpCmd.toStdString() << endl;                                               // *****  debug

	emit sigPpChkEnd(bPpD);
}

void PlayerProc::ppProcPrep(const QString& sPpD)	// prepare player - full path n name of file to play
{
	slPpProcArgs.clear();
	slPpProcArgs.append(slPpD);							// player options - were passed once during check
	slPpProcArgs.append(sPpD);
	ppProcStart();
}

void PlayerProc::ppProcStart()					// run player process
{
	if (bPlaying == false ) {
		ppPlayerProc = new QProcess(this);
		connect(ppPlayerProc, SIGNAL(readyReadStandardOutput()), this, SLOT(ppProcReadStdOut()));
		connect(ppPlayerProc, SIGNAL(readyReadStandardError()), this, SLOT(ppProcReadStdErr()));
		connect(ppPlayerProc, SIGNAL(finished(int, QProcess::ExitStatus)), this, SLOT(ppProcExit(int, QProcess::ExitStatus)));
		bPlaying = true;
		ppPlayerProc->start(sPpCmd, slPpProcArgs);
	} else {
		cout << "ppProcStart called, while bPlaying = true " << endl;                                               // *****  debug
	}
}

void PlayerProc::ppProcReadStdOut()				// read Stdout of player process
{
	aOutput = ppPlayerProc->readAllStandardOutput();									// read byte array
	if (!aOutput.isEmpty()) {
//		cout << "tlmb: stdout: " << QString(aOutput).trimmed().toStdString() << endl;	// catch output line, mpv song info: video, AV, VO and exit status - currently disabled until there is use for the info
    }
}

void PlayerProc::ppProcReadStdErr()				// read Stderr of player process
{
	aOutput = ppPlayerProc->readAllStandardError();										// read byte array
	if (!aOutput.isEmpty()) {
//		cout << "tlmb: stderr: " << QString(aOutput).trimmed().toStdString() << endl;	// catch output line, currently disabled, mpv is 'spawning' stderr?
	}
}

void PlayerProc::ppProcExit(int iD, QProcess::ExitStatus iD2)	// player process has exited, 0=normal, 1=crash
{
	disconnect(ppPlayerProc, SIGNAL(readyReadStandardOutput()), this, SLOT(ppProcReadStdOut()));
	disconnect(ppPlayerProc, SIGNAL(readyReadStandardError()), this, SLOT(ppProcReadStdErr()));
	disconnect(ppPlayerProc, SIGNAL(finished( int, QProcess::ExitStatus)), this, SLOT(ppProcExit(int, QProcess::ExitStatus)));
	bPlaying = false;
	if (ppPlayerProc->exitStatus() == QProcess::NormalExit) {   // normal exit
		emit sigPpExited(0);
    } else {                                    				// we crashed?
		cout << "tlmb: the player (mpv) process exited unexpected (crashed?) while playing: " << sPpD.toStdString() << endl;                                           // *****  debug
		emit sigPpExited(1);
    }
}
