/*********************************************************************
 *  SPDX-License-Identifier: MIT									 *
 *  Copyright (C) 2023-2025 by Helge Kortendieck  alan@kasmithee.de  *
 *                                                                   *
 *  This file is part of tlmb.                                       *
 *********************************************************************/
#include <iostream>
using namespace std;

#include <QApplication>
#include <QStringList>

#include "tlmb.h"

int main(int argc, char *argv[])
{
QApplication app(argc, argv);
	QStringList slArgs = QApplication::arguments();		// get command line args
	int iArgs = slArgs.count();

	if(iArgs > 1) {
		cout << "\n###  tlmb - the little music box\n"
				"###  Easy to use, Qt6 based music player\n"
				"###  Version 0.9.9\n"
				"###  Copyright (C) 2021-2025 by Helge Kortendieck, alan@kasmithee.de\n"
				"###  Released under the MIT license.\n"
				"###  \n"
				"###  This program requires X11 or wayland and Qt6\n"
				"###  Start the program without argument(s) and check the online help.\n" << endl;
		return 0;
	}

  Tlmb ptlmb;
  ptlmb.show();
  return app.exec();
}

