/*********************************************************************
 *  SPDX-License-Identifier: MIT                                     *
 *  Copyright (C) 2005-2023 by Helge Kortendieck  alan@kasmithee.de  *
 *                                                                   *
 *  This file is part of tlmb.                                       *
 *********************************************************************/

#ifndef _M3U_H_
#define _M3U_H_

#include <QDateTime>
#include <QDir>
#include <QFile>
#include <QFileInfo>
#include <QList>
#include <QObject>
#include <QTextStream>

#include "structs.h"

// ******  debug  *****
#include <iostream>
using namespace std;

	int m3uFileDirChk(const QString& m3usD, const QString& m3usD2);				// enum check dir level of playlist: +0=outside root or type dir do not match or artist/band dir do not match, +1=within root, +10=type dir match, +100=artist/band dir match
	QString m3uFileCreate(const QString& m3usD);								// create new, empty playlist (~/.config/qaplay/qaplay.m3u if m3usD=""), 0=err, 1=success, 2=...
	int m3uFileIsWritable(const QString& m3usD);								// check whether the provided m3u is writable: 0=no, 1=yes
	QStringList m3uFileRead(const QString& m3usD);								// read/import *.m3u playlist
	bool m3uFileRename(const QString& m3usD, const QString& m3usD2);			// rename existing *.m3u - false=err, true=success
	bool m3uFileSaveAs(const QString& m3usD, const QString& m3usD2);			// copy existing *.m3u to new name - false=err, true=success
	bool m3uFileWrite(const QString& m3usD, const QList<StrM3u>& m3uLiItems);	// write m3u - m3u format, list w songs full path n name | false=err, true=success

	QList<StrM3u> m3uItemGetList(const QString& m3usD); // get list with m3u (m3usD) songs in StrM3u form from a m3u playlist, full path/name
//	QString m3uItemGetName(const StrM3u& m3uStrM3uD); 	// return song name, either from #EXTINF: line, tag or full path name
	bool m3uItemExists(const QString& m3usD, const QList<StrM3u>& m3uLiItems); 	// check whether the full path and name already exists in list

	QStringList m3uSlSongsFromStrList(const QList<StrM3u>& m3uLiItems);			// get qstringlist with songs (full path & name) to play from m3u struct list
	QStringList m3uSongGetList(const QString& m3usD);							// get list with songs (full path & name) to play ; m3usD = full path & name of m3u playlist

#endif
