/*********************************************************************
 *  SPDX-License-Identifier: MIT                                     *
 *  Copyright (C) 2005-2023 by Helge Kortendieck  alan@kasmithee.de  *
 *                                                                   *
 *  This file is part of tlmb.                                       *
 *  m3u playlist file functions                                      *
 *********************************************************************/

#include "m3u.h"
	bool bOk;
	bool bExists;

	int m3ui;
	int m3uiD;
	int m3uiD2;
	int m3uiD3;

	QString m3usD;
	QString m3usD2;
	QString m3usD3;
	QString m3usD4;
	QString m3usD5;
	QString m3usD6;

	QStringList m3uSlD;
	QStringList m3uSlD2;

	StrM3u m3uStrD;				// playlist item struct entity
	QList<StrM3u> m3uLiStr;		// list with songs in StrM3u form

// ***********************************
// **  m3u playlist file functions  **
// ***********************************
int m3uFileDirChk(const QString& m3usD, const QString& m3usD2, const QString& m3usD3, const QString& m3usD4)	// current path: root, type dir, artist/band dir, current m3u (path+name) ; enum check dir level of playlist:
{																// +0=outside root or type dir do not match or artist/band dir do not match, +1=within root, +10=type dir match, +100=artist/band dir match
	QFileInfo fi(m3usD4);
	m3usD5 = fi.absolutePath();
	m3uiD = 0;

	m3uiD2 = m3usD.length();
	if (m3usD5.length() >= m3uiD2) {
		if (m3usD == m3usD5.left(m3uiD2)) {				// check for root dir
			m3uiD = 1;										// root dir matches
			m3usD5.remove(0, m3uiD2);						// remove root path from m3u path+name
			
			
			
			// music type and artist/band - might not be available if m3u in root dir
			
		} else {
			return m3uiD;									// outside root dir - abort
		}
	}
	return m3uiD;										// outside root dir - abort
}

QString m3uFileCreate(const QString& m3usD)		// create new, empty playlist, 0=err, 1=success, 2=...
{
	m3usD2 = m3usD;
	if (m3usD2 == "") {
		m3usD2 = QDir::homePath() + "/" + QDateTime::currentDateTime().toString("yyyyMMdd-hhmmss") + ".m3u";
	}
	
	QFileInfo fi(m3usD2);
	if (fi.exists() == true) {					// the file already exists - we bail out, do not replace
		return "0";
	}
	
	m3uLiStr.clear();

	if (m3uFileWrite(m3usD2, m3uLiStr) == 1) {
		return m3usD2;
	} else {
		return "0";
	}
}

int m3uFileIsWritable(const QString& m3usD)		// check whether the provided m3u is writable: 0=no, 1=yes
{
//	m3usD = QDir::home().absolutePath();
//cout << "exists() - QDir::home(): " << m3usD.toStdString() << endl;                                               // *****  debug  *****
	QFileInfo fi(m3usD);
	if (fi.exists() == true and fi.isWritable() == true) {
		m3uiD = 1;									// exists and writable
	} else {
		m3uiD = 0;									// does not exists or not writable
	}
	return m3uiD;
}

QStringList m3uFileRead(const QString& m3usD2)	// read m3u
{
	m3uSlD.clear();
	QFile f(m3usD2);
	if (!f.open(QIODevice::ReadOnly | QIODevice::Text)) {
cout << "m3uFileRead: file open error - m3usD2.count() = " << m3usD2.toStdString() << endl;                                            // *****  debug  *****
		m3uSlD.append("error");
		return m3uSlD;
	}

	QTextStream in(&f);
	while (!in.atEnd()) {
		m3usD3 = in.readLine();
		m3uSlD.append(m3usD3);						// no checks performed !
    }
	f.close();
	return m3uSlD;									// each entry is full path n song, no '#' text
}

bool m3uFileRename(const QString& m3usD, const QString& m3usD2)			// rename existing *.m3u - false=err, true=success
{
	QFile f(m3usD);
	return f.rename(m3usD2);
}

bool m3uFileSaveAs(const QString& m3usD, const QString& m3usD2)			// copy existing *.m3u to new name - false=err, true=success
{
	QFile f(m3usD);
	return f.copy(m3usD2);
}

bool m3uFileWrite(const QString& m3usD, const QList<StrM3u>& m3uLiStr)	// write m3u - m3u file name (full path n name) + m3u str list
{
//	if (m3uLiItems.count() == 0) {											// empty list, do not write
//		m3usD2 = QObject::tr("tlmb - m3uFileWrite: Dude, you called me with an empty playlist!\n Nothing to do. This should never happen!");
//		cout << m3usD2.toStdString() << endl;
//		return 1;															// yes, we return success here - go figure!  Else we would discard the poor, innocent playlist, which is still good
//	}

	QFile f(m3usD);
	if (f.exists() == true) {												// if the m3u exists - create a temporary backup first
		if (f.rename(m3usD + ".bak") != true) {
			m3usD2 = QObject::tr("tlmb: could not create a temporary backup of ") + m3usD + QObject::tr(" Aborting...");
			cout << m3usD2.toStdString() << endl;
			return 0;
		}
	}
	
	f.setFileName(m3usD);
	if (f.open(QFile::WriteOnly | QFile::Text)) {                 			// re-creating m3u playlist with actual songs
		QTextStream stream(&f);
			stream << "#EXTM3U" << "\n";										// 1st line
			if (m3uLiStr.count() > 0) {										// only proceed if any entries
//cout << "m3uFileWrite: m3usD = " << m3usD.toStdString() << endl;                                            // *****  debug  *****
				for (m3ui = 0; m3ui < m3uLiStr.count(); m3ui++) {				// 1 line per double line m3u entry
//cout << "m3uFileWrite: m3usD = " << m3usD.toStdString() << endl;                                            // *****  debug  *****
					m3uStrD = m3uLiStr.at(m3ui);
					stream << "#EXTINF:" + m3uStrD.sSec + "," + m3uStrD.sSongName << "\n";
					stream << m3uStrD.sSongPathName << "\n";
				}
			}
		f.close();

		f.setFileName(m3usD + ".bak");											// remove temporary backup
		if (f.exists() == true) {												// if the m3u.bak exists - delete now
			if (f.remove() == true) {
				return 1;
			} else {
			m3usD2 = QObject::tr("tlmb: could not delete the temporary backup: ") + m3usD + ".bak " + QObject::tr(" . Please delete manually.");
			cout << m3usD2.toStdString() << endl;
				return 0;
			}
		} else {
			return 1;
		}
	} else {
		m3usD2 = QObject::tr("tlmb: Error while saving ") + m3usD + QObject::tr(" . Playlist not saved.");
		cout << m3usD2.toStdString() << endl;
		return 0;
	}
}


// ***********************************
// **  m3u playlist item functions  **
// ***********************************
bool m3uItemExists(const QString& m3usD, const QList<StrM3u>& m3uLiStr) // check whether the full path and name already exists in list
{
	bExists = false;
	if (m3uLiStr.count() > 0) {
		for (m3ui = 0; m3ui < m3uLiStr.count(); m3ui++) {						// each line has one complete m3u double line entry
			if (m3usD == m3uLiStr.at(m3ui).sSongPathName) {					// song already in m3u
				bExists = true;
				break;
			}
		}
	}
	return bExists;
}

QList<StrM3u> m3uItemGetList(const QString& m3usD)	// get list with m3u (m3usD) songs in StrM3u form from a m3u playlist, full path/name
{
	m3uLiStr.clear();
	m3uStrD.sSec = "";
	m3uStrD.sSongName = "";
	m3uStrD.sSongPathName = "";
	m3uSlD2 = m3uFileRead(m3usD);
//cout << "m3uItemGetList: m3uSlD2.count() = " << QString::number(m3uSlD2.count()).toStdString() << endl;                                            // *****  debug  *****

	if (m3uSlD2.count() == 1 and m3uSlD2.at(0) == "error") {						// empty file with m3u identifier or "error" for read/open error
			m3uStrD.sSongName = "Error!" + QObject::tr(" Could not read playlist.");
			m3uLiStr.append(m3uStrD);
	} else {
		if (m3uSlD2.count() == 0 or m3uSlD2.at(0).left(7) != "#EXTM3U") {	// file not starting with #EXTM3U, not a valid playlist, better not use it
			m3uStrD.sSongName = "Error!" + QObject::tr(" Playlist not valid, does not start with '#EXTM3U'. Better not use it.");
			m3uLiStr.append(m3uStrD);
		} else {																	// import songs - no robust error hanling !
			if (m3uSlD2.count() > 2) {													//we could have an empty list
				for (m3ui = 1; m3ui < m3uSlD2.count(); m3ui+=2) {									// each increment will start at a new #EXTINF line - if the m3u is valid...
					m3usD2 = m3uSlD2.at(m3ui);
						m3usD2.remove(0, 8);												// remove #EXTINF:
						m3uiD = m3usD2.indexOf(",");
						m3uStrD.sSec = m3usD2.left(m3uiD);									// set length in seconds
						m3uStrD.sSongName = m3usD2.remove(0, m3uiD + 1);					// remove length+',' , the rest is the name
						m3uStrD.sSongPathName = m3uSlD2.at(m3ui + 1);						// song full path + name in 2nd line of entry pair
						m3uLiStr.append(m3uStrD);
				}
			}
		}
	}
	return m3uLiStr;
}


// ***********************************************
// **  m3u playlist song (path&name) functions  **
// ***********************************************
QStringList m3uSlSongsFromStrList(const QList<StrM3u>& m3uLiStr)	// get qstringlist with songs (full path & name) to play from m3u struct list
{
	m3uSlD.clear();
	if (m3uLiStr.count() > 0) {
		for (m3ui = 0; m3ui < m3uLiStr.count(); m3ui++) {			
			m3uStrD = m3uLiStr.at(m3ui);
			m3uSlD.append(m3uStrD.sSongPathName);
		}
	}
	return m3uSlD;													// each entry is full path n song, no '#' text
}

QStringList m3uSongGetList(const QString& m3usD)	// get list with songs (full path & name) to play ; m3usD = full path & name of m3u playlist
{
	m3uSlD2 = m3uFileRead(m3usD);						// get list with entries from m3u - line by line
	if (m3uSlD2.count() > 0) {
		for (m3ui = 0; m3ui < m3uSlD2.count(); m3ui++) {	// check line by line - eliminate everything starting with a #, leave the songs only (full path & name)
			m3usD2 = m3uSlD2.at(m3ui);
			if (m3usD2.left(1) == "#") {
				m3uSlD2.remove(m3ui);
				m3ui--;
			}
		}
	}

	if (m3uSlD2.count() < 1) {								// not one valid song in list
		m3uSlD2.append("err");
	}
	return m3uSlD2;										// each entry is full path n song, no '#' text
}
