/*********************************************************************
 *  SPDX-License-Identifier: MIT									 *
 *  Copyright (C) 2008-2024 by Helge Kortendieck  alan@kasmithee.de  *
 *                                                                   *
 *  This file is part of qrsyncmgr.                                  *
 *********************************************************************/
#ifndef _STRUCTS_H_
#define _STRUCTS_H_

#include <QString>


struct Rsync {          // set of items that define a rsync operation
  QString name;             // name of rsync definition
  QString lastRun;          // date of last successful run
  QString desc;             // description of rsync definition (longer)
  QString srcMp;            // source dir mount point to check and mount/unmount
  QString destMp;           // destination dir mount point to check and mount/unmount
  QString cmd;              // rsync command(s), one per line
};

struct Mp {             // mount point list structure
  int type;                 // type, 0=source, 1=destination
  QString mp;               // mount point as in /etc/fstab
};


#endif  // _STRUCTS_H_

