/*********************************************************************
 *  SPDX-License-Identifier: MIT									 *
 *  Copyright (C) 2006-2026 by Helge Kortendieck  alan@kasmithee.de  *
 *                                                                   *
 *  This file is part of qrsyncmgr.                                  *
 *********************************************************************/
#ifndef _QRM_H_
#define _QRM_H_

#include <QCursor>
#include <QDir>
#include <QFileDialog>
#include <QInputDialog>
#include <QLineEdit>
#include <QListWidget>
#include <QListWidgetItem>
#include <QMainWindow>
#include <QMenuBar>
#include <QMessageBox>
#include <QPoint>
#include <QSettings>
#include <QSize>
#include <QStatusBar>
#include <QString>
#include <QStringList>
#include <QTextEdit>
#include <QToolBar>
#include <QWidget>

#include "ui_qrm.h"
#include "abouthelp.h"
#include "rsync.h"
#include "rwdefs.h"
#include "structs.h"

#include <iostream>
using namespace std;

class Qrmgr : public QMainWindow
{
  Q_OBJECT

    public:
		Qrmgr(QMainWindow *parent = 0);
			~Qrmgr();

private:
	bool bD;
	bool bDefChgd;    		// rsync definition was changed, ask if selecting a new one without saving
	bool bQuit;       		// flag whether we want to quit
	bool bRwdNewEntry;		// flag whether we added a new entry, should be selected in list of rsyncs

	int iAddDelUpd; 		// int to define what action to do, add=0, delete=1 or update=2 the current rsync definition
	int iD;        			// dummy, yeah, good for nothing
	int iD2;
	int iErr;        		// error code from rsync: 0=no error, 1=error 23=some files could not be transferred
	int iErrDirChk;  		// error status while checking directory with rsync definitions: exists 0/1 + readable 0/2 + writeable 0/4 + has defs 0/8 = 0,1,3,7,11,15
	int iQRM;     			// qrsyncmgr output message, add prefix '>>>   qrsyncmgr   '
	int iOpCount;   		// counter for output lines, clear output after 350 lines (rsync and main only)
	int iRet;
	int iRsync;      		// selected rsync in lb_Rsyncs, index starts with 0 for 1st item
	int iRwdButs;    		// enable=1 or disable=2 buttons to manage rsync definitions
	int iSyncing;			// rsync status: 0=undefined, 1=not possible, rsync not found, 2=not syncing, 3=rsync currently running
	int iWShown;			// popup widget currently shown: 0=none, 1=about, 2=help, 3=settings dlg
	int iWToShow;			// chk n show this widget
	int iX;
	int iY;

	Ui::Qrmgr ui;   		// GUI

	QAction *startAct;		// start rsync
	QAction *disabledAct;	// rsync disabled - undefined or rsync not found
	QAction *stopAct;		// stop current rsync
	QAction *exitAct;
	QAction *helpAct;
	QAction *aboutAct;

	QListWidgetItem* qlwiD;     // dummy qlistwidget item
	QListWidgetItem* qlwiItem;  // qlistwidget item

	QMenu *fileMenu;		// file menu
	QMenu *rsyncMenu;		// sync (update) normalized copy collection with master collection
	QMenu *helpMenu;		// help menu

	QPoint qPos;			// cursor position
	QPoint qPosD;			// qpoint dummy

	Rsync rsyncD;       	// dummy item of a single rsync definition

	QString sD;           	// dummy
	QString sD2;
	QString sDir;         	// directory with rsync definition
	QString sErr;         	// error text
	QString sErrT;        	// error dialog title
	QString sRsync;       	// current rsync name from qlistwidget
	QString sRsyncAD;		// rsync name after deleting current successfully
	QString sLastRun;
	QString sMsg;         	// message to add to the output widget
	QString sOutput;      	// output to be added to output widgets
	QString sRwdNewEntry; 	// name of just added new entry, should be selected after re-reading the list of def rsyncs
	QString sWarn;        	// warning, when successful rsync (rsyncOk) with errors

	QStringList slD;
	QStringList slRsyncs;  	// the names of the defined rsyncs

	QToolBar *toolBar;

	AboutHelp *ahw;   		// help widget
	rwdefs *rwd;         	// qobject to handle read/write of rsync definitions
	rsync *rsy;       		// qobject to handle rsync

private slots:
	void ahwCreate();		// create about/help dialog widget
	void ahwDel();			// hide=delete later about/help dialog widget
	void about();         	// show about information, about button was clicked
	void help();           	// show help message, help button was clicked
	void quitPrep();       	// quit clicked clean up, quit button was clicked
	void quitDo();          // finally quit the program

	void actionsCreate();					// create actions
	void menuCreate();						// create menu
	void toolBarCreate();					// create toolbar
	void statusBarCreate();					// create statusbar
	void updMnTlBr();						// update menu and toolbar
	void statusBarUpd(const QString& sD);	// update statusbar

	void addOutput(const QString& sD, int iD);  // add sOutput to output widget, iD=1 = qrsyncmgr message

	void clickedStart();			// start button was clicked
	void clickedStop();				// stop button was clicked
	void clickedQuit();				// quit button was clicked
	void clickedItem(QListWidgetItem* qlwiD); // qlistwidget item was clicked
	void clickedDefClr();			// clicked on clear form from rsync definitions
	void clickedDefAdd();			// clicked on add new rsync definition
	void clickedDefUpd();			// clicked on update current rsync definition
	void clickedDefDel();			// clicked on delete current rsync definition

	void defChgd();					// rsync definition has changed

	void getCurPos();				// get cursor position to show a message close by

	void initChkRsyncDir();			// check dir with rsyncs
	void initChkRsyncDirRet(const QString& sD, const QString& sD2, int iD);	// return from directory check
	void initChkProgs();			// check for rsync
	void initChkProgsRet(int iD);	// check for rsync return, 0=not found 1=found
	void initFin();					// finalize init

	void butCtrl();					// set buttons acc. rsync definition filed updates
	void butDef(int iRwdButs);		// rsync definition buttons 0=disabled 1=enabled, buttons to manage rsync definitions

	void rsyncStart();                                      // start rsync (qprocess)
	void rsyncStopped();                                    // got signal that rsync has been stopped on user request
	void rsyncEnd(const QString& sD, int iD, const QString& sD2); // rsync has ended successfully: last run date, error, warning string
	void rsyncErr(const QString& sD, const QString& sD2); 	// show error message from rsync qobject

	void rwdDefAddDelUpd();                               	// add, delete or update the current rsync definition
	void rwdClearForm();                                  	// clear all widgets of a rsync define
	void rwdErr(const QString& sD, const QString& sD2); 	// show error message from rwdefs qobject
	void rwdGetDetails();                                 	// get rsync details (fields)
	void rwdSetCurIt(const QString sD);        	// set current item

	void rwdUpdDetails(const Rsync& rsync);    	// get and show details for selected rsync
	void rwdUpdList(const QStringList& slD);    // update widget with list of rsyncs

	void setDir();              				// set directroy with rsync definitions, file open dialog button was clicked

	void settingsRead();        				// read settings (client mode data)
	void settingsWrite();       				// write settings (client mode data)
  
  	void wCtrl(int iWToShow);					// show popup widget, if no other is shown: 0=none, 1=about, 2=help

	signals:
		void sigAhwShow(int iD);				// show info dlg: about, help, error no system tray

		void sigRsyChkProgs();					// check whether rsync and ask-pass are installed
		void sigRsyStart(const QString& sD);	// signal to stop rsync on user request
		void sigRsyStop();						// signal to stop rsync on user request

		void sigRwdAdd(const Rsync& rsync);       	// do add rsync definition
		void sigRwdChkDir(const QString& sDir);   	// check directory with rsync definitions
		void sigRwdDel(const QString& sD);        	// do delete rsync definition
		void sigRwdGetDetails(const QString& sD); 	// get rsync details (fields)
		void sigRwdGetRsyncs();                     // read defined rsyncs (names)
		void sigRwdUpd(const Rsync& rsync );       	// do update rsync definition
};

#endif

