/*********************************************************************
 *  SPDX-License-Identifier: MIT                                     *
 *  Copyright (C) 2006-2026 by Helge Kortendieck  alan@kasmithee.de  *
 *                                                                   *
 *  This file is part of qrsyncmgr.                                  *
 *********************************************************************/
#include "qrm.h"

#include <QApplication>
#include <QStringList>

#include <iostream>
using namespace std;

int main(int argc, char **argv)
{
	QApplication app(argc, argv);
	QStringList slArgs = QApplication::arguments();   // get command line args
	int iArgs = slArgs.count();

	if(iArgs > 1) {
		cout << "\n###  qrsyncmgr - a small tool to manage your rsyncs\n"
			"###  Version 3.0.2\n"
			"###  Copyright (C) 2006-2026 by Helge Kortendieck, alan@kasmithee.de\n"
			"###  Released under the MIT license\n"
			"###  \n"
			"###  Based on Qt6.\n"
			"###  Use 'man qrsyncmgr' to see a short program description.\n"
			"###  To run the program, start it without arguments.\n" << endl;
		return 0;
	}

	Qrmgr qrm;
	qrm.show();
	return app.exec();
}
