/*********************************************************************
 *  SPDX-License-Identifier: MIT									 *
 *  Copyright (C) 2007-2024 by Helge Kortendieck  alan@kasmithee.de  *
 *                                                                   *
 *  This file is part of qrsyncmgr.                                  *
 *********************************************************************/
#ifndef _ABOUTHELP_H_
#define _ABOUTHELP_H_

#include <QDialog>
#include <QPoint>

#include "ui_abouthelp.h"


class AboutHelp : public QDialog
{
    Q_OBJECT

public:
	AboutHelp(QDialog* parent = 0  );
		~AboutHelp();

private:
	int iD;
	int iD2;
	int iDlg;					// dialog type: 1=about, 2=help, 3=no tray icon
	
	Ui::Help uih;				// help widget

	QDialog wHelp;				// help widget

	QPoint qPos;

	QString sHelp;				// about/help text

private slots:
	void dlgClose();			// close dialog
	void dlgShow( int iD );		// show dialog: 1=about, 2=help, 3=no tray icon

	void textSet();				// set text to show acc dialog type

	signals:
		void sigDelAhw();
};

#endif
