/*********************************************************************
 *  SPDX-License-Identifier: MIT									 *
 *  Copyright (C) 2007-2026 by Helge Kortendieck  alan@kasmithee.de  *
 *                                                                   *
 *  This file is part of qrsyncmgr.                                  *
 *********************************************************************/
#include "abouthelp.h"

AboutHelp::AboutHelp( QDialog* parent )
	: QDialog( parent )
{
	uih.setupUi(&wHelp);
	connect(uih.pB_Close, SIGNAL(clicked()), this, SLOT(dlgClose()));
}

AboutHelp::~AboutHelp()
{
}

void AboutHelp::dlgShow(int iD)			// show dialog: 1=about, 2=Help, 3=no system tray
{
	iDlg = iD;
	if (wHelp.isVisible() == true) {
		wHelp.hide();
	}
	textSet();
	if (iDlg == 1) {
		uih.tb_Help->setHtml(sHelp);
		wHelp.setWindowTitle(tr("about qrsyncmgr"));
		wHelp.resize(640, 220);
	} else if (iDlg == 2) {
		uih.tb_Help->setHtml(sHelp);
		wHelp.setWindowTitle(tr("qrsyncmgr - help"));
		wHelp.showFullScreen();
	}
	if (iDlg == 1) {							// 1=about
		qPos = QCursor::pos();
		iD = qPos.x() - 450;
		if (iD < 0) {
			iD = 0;
		}
		iD2 = qPos.y() - 175;
		if (iD2 < 0) {
			iD2 = 0;
		}
		wHelp.move(iD, iD2);
	}
	wHelp.show();
}

void AboutHelp::dlgClose()
{
	wHelp.hide();
	emit sigDelAhw();
}

void AboutHelp::textSet()
{
	if (iDlg == 1) {
		sHelp = tr("<html><body>"
                  "qrsyncmgr - GUI front end to manage your rsyncs, Qt6 based.<br>"
                  "Version 3.0.2<br>"
		          "(C) 2006-2026 by Helge Kortendieck, alan@kasmithee.de<p>"
                  "This program is released under the MIT license."
                  "</body></html>");
	} else if (iDlg == 2) {
		sHelp = tr("<html><body>"
                  "<a name=""Top""><b>Table of content</b></a><br>"
                  "<a href=""#Intro"">Introduction</a><br>"
                  "<a href=""#Start"">Starting</a><br>"
                  "<a href=""#Options"">Command line options</a><br>"
                  "<a href=""#Root"">Syncing as root</a><br>"
                  "<a href=""#Notes"">A note regarding rsync and backups</a><br>"
                  "<a href=""#Tip"">Tip: avoid lost+found errors</a><br>"
                  "<a href=""#Examples"">Examples</a><br>"
                  "<a href=""#Credits"">Credits</a><p>"

                  "<hr>"
                  "<a name=""Intro""><b><u>Introduction</u></b></a><p>"
                  "qrsyncmgr is a GUI program based on Qt6 to help managing and running different rsync definitions.<p>"
                  "rsync is a tool to synchronize a 2nd (backup) directory with a master directory. "
                  "It does not support a bi-directional synchronisation. Look into e. g. unison for that.<p>"
                  "qrsyncmgr provides an overview and easy access to the rsync definitions, allows to run a synchronisation and tracks the date "
				  "a rsync was last run.<br>"
                  "It is possible to define multiple rsyncs within one definition. They will all run one after each other.<br>"
                  "As already mentioned, the date of the last successful run of a definition is saved.<br>"
                  "Any remote/external target directories must be mounted before starting qrsyncmgr.<br>"
                  "Knowledge about rsync must already exist, as qrsyncmgr is not designed to give serious help on developing a desired "
                  "rsync command line. See 'man rsync' for more information on rsync.<p>"
                  "While the rsync command line is not limited, qrsyncmgr is intended to be used for not too complex rsyncs (home use).<p>"
                  "<a href=""#Top"">back to top</a><p>"

                  "<hr>"
                  "<a name=""Start""><b><u>Starting</u></b></a><p>"
                  "Start qrsyncmgr by calling just this name as a command. However, on a desktop supporting freedesktop.org, a menu entry should "
                  "have been added in the Utility sub-menu.<p>"
                  "If you start the program for the first time, set a directory for storing all your rsync definitions in the upper left of the screen.<p>"
                  "Now define a rsync in the upper right part of the screen, save it and try to run it.<p>"
                  "Always ensure that any partition that is used by rsync is properly mounted before starting a rsync run.<p>"
                  "<a href=""#Top"">back to top</a><p>"

                  "<hr>"
                  "<a name=""Options""><b><u>Command line options</u></b></a><p>"
                  "Starting qrsyncmgr with any command line argument will give you a help/version information message on standard out (the console).<p>"
                  "<a href=""#Top"">back to top</a><p>"

                  "<hr>"
                  "<a name=""Root""><b><u>Syncing as root</u></b></a><p>"
                  "A first and ultimtive advise: DON'T !<br>"
                  "Running programs as root is in general not recommended due to safety/security problems which come with it.<p>"
                  "However, often the data that should be backed up has different user access rights and trying to synchronizing this data "
                  "as a standard user will fail with insufficient access permission rights, either on the source side or on the destination side.<br>"
                  "In that case running qrsyncmgr as root can solve the problem(s). Always with the risk that an incorrect rsync definition can "
				  "destroy the target system.<p>"
                  "<a href=""#Top"">back to top</a><p>"  

                  "<hr>"
                  "<a name=""Notes""><b><u>A note regarding rsync and backups</u></b></a><p>"
                  "rsync is used to keep a directory in sync with a master directory. It will compare the files in both directories and update only those "
                  "portions of a file, that have changed and not store/transfer the complete file again. Especially on large files with only minor changes "
                  "in them, this method saves a lot of time and bandwidth. That's the reason why rsync is often used when syncing servers over the net.<p>"
                  "Among the many settings, the '--delete' setting is important.<br>"
                  "When used, a file deleted on the master server will be deleted on the backup server as well. This is important if you have a huge amount "
                  "of data and for instance change the directory structure/sorting order of your files on the master server.<br>"
                  "If you use the '--delete' option, after the rsync run has been completed, the backup server will hold the same data as the master server.<br>"
                  "However, if you don't use this option, you may end up having the files stored twice on the backup server, once in the original structure "
                  "and the second time in the now actual structure from the master server.<br>"
                  "So not using the '--delete' option will most likely cause storage space problems on the backup server, if you for instance sync two "
                  "disks of the same size.<br>"
                  "On the other hand, using the '--delete' option will delete any data, which was deleted or moved on the master server. Thus, a backup of "
                  "the master can only prevent against hardware failures but not logical errors. E. g. accidentally deleting a file on the master, rsyncing "
                  "and then becoming aware of the error. The file will be lost in the backup as well.<p>"
                  "So a backup via rsync with the '--delete' option can never replace a real backup creating a frozen snapshot of the master server data !<p>"
                  "<a href=""#Top"">back to top</a><p>"

                  "<hr>"
                  "<a name=""Tip""><b><u>Tip: avoid lost+found errors</u></b></a><p>"
                  "In order to prevent rsync errors about not being able to copy a lost+found directory, it should be excluded in the rsync definition.<br>"
                  "The lost+found directory, used to collect re-allocated lost=invalid blocks/disk space, is usually only readable by root.<br>"
                  "This directory should be excluded in the rsync definition somehow like this: rsync command(s) line/definition:<br>"
                  "-av --exclude=lost+found /tmp/ /tmp2<br>"
                  "Here the '--exclude=lost+found' option will exclude the 'lost+found' directory. See man rsync for more information about the '--exclude' option.<p>"                  
                  "<a href=""#Top"">back to top</a><p>"

                  "<hr>"
                  "<a name=""Examples""><b><u>Examples</u></b></a><p>"
				  "Some small examples. See 'man rsync' for more information. Make sure that all required partitions are mounted prior a rsync run!<p>"
                  "<b>qrsyncmgr</b> - will start the program.<p>"
				  "<b>-av --exclude=lost+found /tmp/src/ /tmp/dest</b><br>"
                  "A simple example of a rsync within the local PC.<br>"
                  "Notice the '/' at the end of the '/tmp/src/' parameter in the rsync command line. With that, the content of /tmp/src will be "
                  "copied into /tmp/dest . Without it, it would be copied into /tmp/dest/src !<br>"
				  "-av - archive (a combination of several rsync options including -r = recursive) and verbose option<br>"
				  "--exclude=lost+found - exclude the lost+found directory from syncing.<p>"
				  "<b>-av --delete --exclude=lost+found --size-only /tmp/src/ /tmp/dest</b><br>"
                  "Same as before, but rsync with '--delete' option. So any file not present in the source directory will be deleted from the "
                  "destination directory. This ensures, that the destination directory will be an exact copy of the source directory after a "
				  "successful rsync.<br>"
                  "Please read the <a href=""#Notes"">A note regarding rsync and backups</a> section about the danger when using the '--delete' "
				  "option for backups.<br>"
				  "The '--size-only' option skips files that have a different last-modified time e. g. because they were copied not by rsync.<br>"
				  "--delete - delete all files in the target directory which are not present in the source directory<br>"
				  "--size-only - do not copy files that differ only in the last-modified time (but have the exact same file size).<p>"
                  "<a href=""#Top"">back to top</a><p>"

                  "<hr>"
                  "<a name=""Credits""><b><u>Credits</u></b></a><p>"
                  "Icons where taken from the following themes made by the listed persons:<br>"
                  "Programs internal action icons are either taken from the Tango theme or the open_icon_library-GPL-0.10 .<br>"
				  "See http://openiconlibrary.sourceforge.net/ licenses see: LICENSES_full_documentation_gpl.txt .<br>"
				  "- about.svg - open icon library version 10 Nov. 2009, actions/help-about.svg, gnome, GPLv2<br>"
				  "- disabled.svg - Tango arch 20101027, actions/media-playback-stop.svg, PD<br>"
				  "- exit.svg - open icon library version 10 Nov. 2009, actions/application-exit-3.svg, gnome-Colors, GPLv2<br>"
				  "- help.svg - open icon library version 10 Nov. 2009, apps/help-browser.svg, gnome, GPLv2<br>"
				  "- info.svg - open icon library version 10 Nov. 2009, actions/help-about-3.svg, oxygen, CC-BY-SA 3.0 or LGPL<br>"
				  "- open.svg - open icon library version 10 Nov. 2009, actions/document-open-5.svg, tango, PD<br>"
				  "- start.svg - Tango arch 20101028, actions/go-next.svg, PD<br>"
				  "- stop.svg - open icon library version 10 Nov. 2009, actions/process-stop-7.svg, oxygen, CC-BY-SA 3.0 or LGPL<br>"
				  "- warning.svg - open icon library version 10 Nov. 2009, status/dialog-warning.svg, gnome, GPLv2<br>"
                  "The base for the program icon is 'devices/drive-harddisk-8.svg' from the oxygen SVG icon theme. Made by Everaldo.com Design Studio, CC-BY-SA 3.0 or LGPL.<br>"
                  "The program icon was created by me, Helge Kortendieck, using inkscape.<p>"
                  "qrsyncmgr is based on Qt6 and calls rsync and ssh-askpass, without these programs it could not exist!<p>"
                  "Program and Documentation Copyright 2008-2024 Helge Kortendieck, alan@kasmithee.de .<p>"
                  "qrsyncmgr is released under the MIT license.<p>"
                  "<a href=""#Top"">back to top</a><p>"
                  "</body></html>") ;
	}
}

